/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;

public abstract class BaseSerializerProvider
implements SerializerProvider {
    private static final String ANY_MEDIA_TYPE = "*/*";
    private final Map<String, Serializer> serializerMap;
    private final String defaultMediaType;

    public BaseSerializerProvider(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
        this.serializerMap = new HashMap<String, Serializer>();
    }

    @Override
    @Nonnull
    public Serializer getSerializer(String mediaType) {
        Serializer serializer = ANY_MEDIA_TYPE.equals(mediaType = mediaType.contains(";") ? mediaType.substring(0, mediaType.indexOf(";")).trim().toLowerCase(Locale.US) : mediaType.toLowerCase(Locale.US).trim()) ? this.serializerMap.get(this.defaultMediaType) : this.serializerMap.get(mediaType);
        if (serializer == null) {
            throw new IllegalArgumentException("No serializer for media type '" + mediaType + "'");
        }
        return serializer;
    }

    @Override
    @Nonnull
    public Serializer getDefault() {
        return this.getSerializer(this.defaultMediaType);
    }

    protected void register(Serializer serializer, String ... mediaTypes) {
        for (String mediaType : mediaTypes) {
            this.serializerMap.put(mediaType.trim().toLowerCase(Locale.US), serializer);
        }
    }
}

