/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PPrimitiveProvider;
import net.morimekta.util.Binary;

public class PPrimitive
implements PDescriptor {
    public static final PPrimitive VOID = new PPrimitive(PType.VOID, Void.TYPE, null, true);
    public static final PPrimitive BOOL = new PPrimitive(PType.BOOL, Boolean.TYPE, false, true);
    public static final PPrimitive BYTE = new PPrimitive(PType.BYTE, Byte.TYPE, (byte)0, true);
    public static final PPrimitive I16 = new PPrimitive(PType.I16, Short.TYPE, (short)0, true);
    public static final PPrimitive I32 = new PPrimitive(PType.I32, Integer.TYPE, 0, true);
    public static final PPrimitive I64 = new PPrimitive(PType.I64, Long.TYPE, 0L, true);
    public static final PPrimitive DOUBLE = new PPrimitive(PType.DOUBLE, Double.TYPE, 0.0, true);
    public static final PPrimitive STRING = new PPrimitive(PType.STRING, null, "", false);
    public static final PPrimitive BINARY = new PPrimitive(PType.BINARY, null, Binary.empty(), false);
    private final PPrimitiveProvider provider;
    private final PType type;
    private final Object defaultValue;
    private final boolean nativePrimitive;
    private final Type nativeType;

    private PPrimitive(PType type, Type nativeType, Object defValue, boolean nativePrimitive) {
        this.type = type;
        this.nativeType = nativeType;
        this.provider = new PPrimitiveProvider(this);
        this.defaultValue = defValue;
        this.nativePrimitive = nativePrimitive;
    }

    @Nonnull
    public PPrimitiveProvider provider() {
        return this.provider;
    }

    @Override
    public String getProgramName() {
        return null;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.type.toString();
    }

    @Override
    @Nonnull
    public String getQualifiedName(String programContext) {
        return this.type.toString();
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    @Nonnull
    public PType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.defaultValue});
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNativePrimitive() {
        return this.nativePrimitive;
    }

    public static PPrimitive findByName(String name) {
        switch (name) {
            case "void": {
                return VOID;
            }
            case "bool": {
                return BOOL;
            }
            case "byte": 
            case "i8": {
                return BYTE;
            }
            case "i16": {
                return I16;
            }
            case "i32": {
                return I32;
            }
            case "i64": {
                return I64;
            }
            case "double": {
                return DOUBLE;
            }
            case "string": {
                return STRING;
            }
            case "binary": {
                return BINARY;
            }
        }
        return null;
    }

    public Type getNativeType() {
        return this.nativeType;
    }
}

