/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Collections;
import java.util.Map;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSortedMap;

public class PMap<Key, Value>
extends PContainer<Map<Key, Value>> {
    private final PDescriptorProvider keyDescriptor;
    private final IntFunction<Builder<Key, Value>> builderSupplier;

    public PMap(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc, IntFunction<Builder<Key, Value>> builderSupplier) {
        super(itemDesc);
        this.keyDescriptor = keyDesc;
        this.builderSupplier = builderSupplier;
    }

    public PDescriptor keyDescriptor() {
        return this.keyDescriptor.descriptor();
    }

    @Override
    @Nonnull
    public String getName() {
        return "map<" + this.keyDescriptor().getName() + "," + this.itemDescriptor().getName() + ">";
    }

    @Override
    @Nonnull
    public String getQualifiedName(String programContext) {
        return "map<" + this.keyDescriptor().getQualifiedName(programContext) + "," + this.itemDescriptor().getQualifiedName(programContext) + ">";
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.MAP;
    }

    @Override
    @Nullable
    public Object getDefaultValue() {
        return Collections.EMPTY_MAP;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PMap)) {
            return false;
        }
        PMap other = (PMap)o;
        return other.itemDescriptor().equals(this.itemDescriptor()) && other.keyDescriptor().equals(this.keyDescriptor());
    }

    public int hashCode() {
        return PMap.class.hashCode() + this.itemDescriptor().hashCode() + this.keyDescriptor().hashCode();
    }

    @Nonnull
    public Builder<Key, Value> builder(int capacity) {
        return this.builderSupplier.apply(capacity);
    }

    @Nonnull
    public static <K, V> PContainerProvider<Map<K, V>, PMap<K, V>> provider(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc) {
        return PMap.provider(keyDesc, itemDesc, DefaultBuilder::new);
    }

    @Nonnull
    public static <K extends Comparable<K>, V> PContainerProvider<Map<K, V>, PMap<K, V>> sortedProvider(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc) {
        return PMap.provider(keyDesc, itemDesc, SortedBuilder::new);
    }

    @Nonnull
    public static <K, V> PContainerProvider<Map<K, V>, PMap<K, V>> orderedProvider(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc) {
        return PMap.provider(keyDesc, itemDesc, OrderedBuilder::new);
    }

    private static <K, V> PContainerProvider<Map<K, V>, PMap<K, V>> provider(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc, IntFunction<Builder<K, V>> builderFactory) {
        return new PContainerProvider<Map<K, V>, PMap<K, V>>(new PMap(keyDesc, itemDesc, builderFactory));
    }

    public static class OrderedBuilder<K, V>
    extends DefaultBuilder<K, V> {
        public OrderedBuilder() {
        }

        public OrderedBuilder(int capacity) {
            super(capacity);
        }
    }

    public static class SortedBuilder<K extends Comparable, V>
    implements Builder<K, V> {
        private UnmodifiableSortedMap.Builder<K, V> builder;

        public SortedBuilder() {
            this(10);
        }

        public SortedBuilder(int capacity) {
            this.builder = UnmodifiableSortedMap.builderNaturalOrder((int)capacity);
        }

        @Override
        @Nonnull
        public Builder<K, V> put(@Nonnull K key, @Nonnull V value) {
            this.builder.put(key, value);
            return this;
        }

        @Override
        @Nonnull
        public Builder<K, V> putAll(@Nonnull Map<K, V> items) {
            this.builder.putAll(items);
            return this;
        }

        @Override
        @Nonnull
        public Map<K, V> build() {
            return this.builder.build();
        }
    }

    public static class DefaultBuilder<K, V>
    implements Builder<K, V> {
        private UnmodifiableMap.Builder<K, V> builder;

        public DefaultBuilder() {
            this(10);
        }

        public DefaultBuilder(int capacity) {
            this.builder = UnmodifiableMap.builder((int)capacity);
        }

        @Override
        @Nonnull
        public Builder<K, V> put(@Nonnull K key, @Nonnull V value) {
            this.builder.put(key, value);
            return this;
        }

        @Override
        @Nonnull
        public Builder<K, V> putAll(@Nonnull Map<K, V> items) {
            this.builder.putAll(items);
            return this;
        }

        @Override
        @Nonnull
        public Map<K, V> build() {
            return this.builder.build();
        }
    }

    public static interface Builder<K, V>
    extends PBuilder<Map<K, V>> {
        @Nonnull
        public Builder<K, V> put(@Nonnull K var1, @Nonnull V var2);

        @Nonnull
        public Builder<K, V> putAll(@Nonnull Map<K, V> var1);

        @Override
        @Nonnull
        public Map<K, V> build();
    }
}

