/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.pretty;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import net.morimekta.util.CharSlice;
import net.morimekta.util.Strings;

public class Token
extends CharSlice {
    public static final char kGenericStart = '<';
    public static final char kGenericEnd = '>';
    public static final char kMessageStart = '{';
    public static final char kMessageEnd = '}';
    public static final char kKeyValueSep = ':';
    public static final char kFieldValueSep = '=';
    public static final char kParamsStart = '(';
    public static final char kParamsEnd = ')';
    public static final char kListStart = '[';
    public static final char kListEnd = ']';
    public static final char kLineSep1 = ',';
    public static final char kLineSep2 = ';';
    public static final char kIdentifierSep = '.';
    public static final char kLiteralEscape = '\\';
    public static final char kLiteralQuote = '\'';
    public static final char kLiteralDoubleQuote = '\"';
    public static final char kShellComment = '#';
    public static final char kNewLine = '\n';
    public static final char kCarriageReturn = '\r';
    public static final char kSpace = ' ';
    public static final char kTab = '\t';
    public static final String B64 = "b64";
    public static final String HEX = "hex";
    public static final String kSymbols = "{}:=()<>,;#[]&/*|%$@^";
    private static final Pattern RE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_DOUBLE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_REFERENCE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*([.][_a-zA-Z][_a-zA-Z0-9]*)*");
    private static final Pattern RE_INTEGER = Pattern.compile("-?(0|[1-9][0-9]*|0[0-7]+|0x[0-9a-fA-F]+)");
    private static final Pattern RE_REAL = Pattern.compile("-?(0?\\.[0-9]+|[1-9][0-9]*\\.[0-9]*)([eE][+-]?[0-9][0-9]*)?");
    private final int lineNo;
    private final int linePos;

    public Token(char[] fb, int off, int len, int lineNo, int linePos) {
        super(fb, off, len);
        this.lineNo = lineNo;
        this.linePos = linePos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !((Object)((Object)this)).getClass().equals(o.getClass())) {
            return false;
        }
        Token other = (Token)((Object)o);
        return this.asString().equals(other.asString()) && this.len == other.len && this.off == other.off && this.lineNo == other.lineNo && this.linePos == other.linePos;
    }

    public int hashCode() {
        return Objects.hash(Token.class, Arrays.hashCode(this.fb), this.off, this.len, this.lineNo, this.linePos);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public boolean isSymbol(char symbol) {
        return this.len == 1 && this.fb[this.off] == symbol;
    }

    public boolean isStringLiteral() {
        return this.length() > 1 && (this.charAt(0) == '\"' && this.charAt(-1) == '\"' || this.charAt(0) == '\'' && this.charAt(-1) == '\'');
    }

    public boolean isIdentifier() {
        return RE_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isQualifiedIdentifier() {
        return RE_QUALIFIED_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isDoubleQualifiedIdentifier() {
        return RE_DOUBLE_QUALIFIED_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isReferenceIdentifier() {
        return RE_REFERENCE_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isInteger() {
        return RE_INTEGER.matcher(this.asString()).matches();
    }

    public boolean isReal() {
        return RE_REAL.matcher(this.asString()).matches();
    }

    public boolean strEquals(String str) {
        return super.strEquals(str.toCharArray());
    }

    public String decodeLiteral(boolean strict) {
        String tmp = this.substring(1, -1).asString();
        int l = tmp.length();
        StringBuilder out = new StringBuilder(l);
        boolean esc = false;
        for (int i = 0; i < l; ++i) {
            if (esc) {
                esc = false;
                char ch = tmp.charAt(i);
                switch (ch) {
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        out.append(ch);
                        break;
                    }
                    case 'u': {
                        int cp;
                        String n;
                        if (l < i + 5) {
                            if (strict) {
                                throw new IllegalArgumentException("Invalid escaped unicode char: '\\" + Strings.escape((CharSequence)tmp.substring(i)) + "'");
                            }
                            out.append('?');
                        } else {
                            n = tmp.substring(i + 1, i + 5);
                            try {
                                cp = Integer.parseInt(n, 16);
                                out.append((char)cp);
                            }
                            catch (NumberFormatException e) {
                                if (strict) {
                                    throw new IllegalArgumentException("Invalid escaped unicode char: '\\u" + Strings.escape((CharSequence)n) + "'");
                                }
                                out.append('?');
                            }
                        }
                        i += 4;
                        break;
                    }
                    case '0': {
                        if (l == i + 1 || l > i + 1 && (tmp.charAt(i + 1) < '0' || tmp.charAt(i + 1) > '9')) {
                            out.append('\u0000');
                            break;
                        }
                    }
                    case '1': {
                        int cp;
                        String n;
                        if (l < i + 3) {
                            if (strict) {
                                throw new IllegalArgumentException("Invalid escaped char: '\\" + Strings.escape((CharSequence)tmp.substring(i)) + "'");
                            }
                            out.append('?');
                        } else {
                            n = tmp.substring(i, i + 3);
                            try {
                                cp = Integer.parseInt(n, 8);
                                out.append((char)cp);
                            }
                            catch (NumberFormatException e) {
                                if (strict) {
                                    throw new IllegalArgumentException("Invalid escaped char: '\\" + Strings.escape((CharSequence)n) + "'");
                                }
                                out.append('?');
                            }
                        }
                        i += 2;
                        break;
                    }
                    default: {
                        if (strict) {
                            throw new IllegalArgumentException("Invalid escaped char: '\\" + Strings.escape((CharSequence)String.valueOf(ch)) + "'");
                        }
                        out.append('?');
                        break;
                    }
                }
                continue;
            }
            if (tmp.charAt(i) == '\\') {
                esc = true;
                continue;
            }
            if (!Strings.isConsolePrintable((int)tmp.codePointAt(i))) {
                if (strict) {
                    throw new IllegalArgumentException("Unescaped string char: '" + Strings.escape((CharSequence)String.valueOf(tmp.charAt(i))) + "'");
                }
                out.append('?');
                continue;
            }
            out.append(tmp.charAt(i));
        }
        return out.toString();
    }

    public String toString() {
        return String.format("Token('%s',%d:%d-%d)", this.asString(), this.lineNo, this.linePos, this.linePos + this.len - 1);
    }

    public int getOffset() {
        return this.off;
    }
}

