/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptorProvider;

public class PList<Item>
extends PContainer<List<Item>> {
    private final Supplier<Builder<Item>> builderSupplier;

    public PList(PDescriptorProvider itemType, Supplier<Builder<Item>> builderSupplier) {
        super(itemType);
        this.builderSupplier = builderSupplier;
    }

    @Override
    @Nonnull
    public String getName() {
        return "list<" + this.itemDescriptor().getName() + ">";
    }

    @Override
    @Nonnull
    public String getQualifiedName(String programContext) {
        return "list<" + this.itemDescriptor().getQualifiedName(programContext) + ">";
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.LIST;
    }

    @Override
    @Nullable
    public Object getDefaultValue() {
        return Collections.EMPTY_LIST;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PList)) {
            return false;
        }
        PList other = (PList)o;
        return other.itemDescriptor().equals(this.itemDescriptor());
    }

    public int hashCode() {
        return PList.class.hashCode() + this.itemDescriptor().hashCode();
    }

    @Override
    @Nonnull
    public Builder<Item> builder() {
        return this.builderSupplier.get();
    }

    @Nonnull
    public static <I> PContainerProvider<List<I>, PList<I>> provider(PDescriptorProvider itemDesc) {
        return PList.provider(itemDesc, DefaultBuilder::new);
    }

    @Nonnull
    public static <I> PContainerProvider<List<I>, PList<I>> provider(PDescriptorProvider itemDesc, Supplier<Builder<I>> builderFactory) {
        return new PContainerProvider<List<I>, PList<I>>(new PList(itemDesc, builderFactory));
    }

    public static class DefaultBuilder<I>
    implements Builder<I> {
        private ImmutableList.Builder<I> builder = ImmutableList.builder();

        @Override
        @Nonnull
        public DefaultBuilder<I> add(@Nonnull I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public DefaultBuilder<I> addAll(@Nonnull Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        @Nonnull
        public List<I> build() {
            return this.builder.build();
        }
    }

    public static interface Builder<I>
    extends PBuilder<List<I>> {
        @Nonnull
        public Builder<I> add(@Nonnull I var1);

        @Nonnull
        public Builder<I> addAll(@Nonnull Collection<I> var1);

        @Override
        @Nonnull
        public List<I> build();
    }
}

