/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.pretty;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.CharSlice;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;

public class Tokenizer
extends Reader {
    private final char[] buffer;
    protected int readOffset;
    protected int lineNo;
    protected int linePos;
    private Token nextToken;

    public Tokenizer(InputStream in, boolean enclosedContent) throws IOException {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        if (enclosedContent) {
            int r;
            int stack = 0;
            int literal = 0;
            boolean escaped = false;
            boolean comment = false;
            while ((r = in.read()) >= 0) {
                tmp.write(r);
                if (comment) {
                    if (r != 10 && r != 13) continue;
                    comment = false;
                    continue;
                }
                if (literal != 0) {
                    if (escaped) {
                        escaped = false;
                        continue;
                    }
                    if (r == literal) {
                        literal = 0;
                        escaped = false;
                        continue;
                    }
                    if (r != 92) continue;
                    escaped = true;
                    continue;
                }
                if (r == 32 || r == 9 || r == 13 || r == 10) continue;
                if (r == 34 || r == 39) {
                    literal = (char)r;
                    continue;
                }
                if (r == 35) {
                    comment = true;
                    continue;
                }
                if (r == 125) {
                    if (--stack > 0) continue;
                    break;
                }
                if (r != 123) continue;
                ++stack;
            }
            while ((r = in.read()) >= 0) {
                tmp.write(r);
                if (r != 10) continue;
                break;
            }
        } else {
            IOUtils.copy((InputStream)in, (OutputStream)tmp);
        }
        this.buffer = new String(tmp.toByteArray(), StandardCharsets.UTF_8).toCharArray();
        this.readOffset = -1;
        this.lineNo = 1;
        this.linePos = 0;
    }

    @Override
    public int read() {
        if (++this.readOffset >= this.buffer.length) {
            this.readOffset = this.buffer.length;
            return -1;
        }
        int ret = this.buffer[this.readOffset];
        if (ret == 10) {
            ++this.lineNo;
            this.linePos = 0;
        } else {
            ++this.linePos;
        }
        return ret > 0 ? ret : 256 + ret;
    }

    @Override
    public int read(char[] chars, int i, int i1) throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    private void unread() {
        if (this.readOffset == this.buffer.length) {
            --this.readOffset;
            return;
        }
        if (this.buffer[this.readOffset--] == '\n') {
            --this.lineNo;
        } else {
            --this.linePos;
        }
    }

    public Token expect(@Nonnull String expected) throws IOException {
        if (!this.hasNext()) {
            throw this.failure("Expected %s, got end of file", expected);
        }
        Token next = this.nextToken;
        this.nextToken = null;
        return next;
    }

    public Token expect(@Nonnull String expected, @Nonnull TokenValidator validator) throws IOException {
        if (!this.hasNext()) {
            throw this.failure("Expected %s, got end of file", expected);
        }
        if (validator.validate(this.nextToken)) {
            Token next = this.nextToken;
            this.nextToken = null;
            return next;
        }
        throw this.failure(this.nextToken, "Expected %s, but got '%s'", expected, Strings.escape((CharSequence)this.nextToken.asString()));
    }

    public Token peek(@Nonnull String expected) throws IOException {
        if (!this.hasNext()) {
            throw this.failure("Expected %s, got end of file", expected);
        }
        return this.nextToken;
    }

    public Token peek() throws IOException {
        this.hasNext();
        return this.nextToken;
    }

    public char expectSymbol(@Nonnull String expected, char ... symbols) throws IOException {
        if (!this.hasNext()) {
            throw this.failure("Expected %s, one of ['%s'], got end of file", expected, Strings.joinP((String)"', '", (char[])symbols));
        }
        for (char symbol : symbols) {
            if (!this.nextToken.isSymbol(symbol)) continue;
            this.nextToken = null;
            return symbol;
        }
        throw this.failure(this.nextToken, "Expected %s, one of ['%s'], but found '%s'", expected, Strings.joinP((String)"', '", (char[])symbols), Strings.escape((CharSequence)this.nextToken.asString()));
    }

    public Token expectIdentifier(@Nonnull String message) throws IOException {
        return this.expect(message, Token::isIdentifier);
    }

    @Nonnull
    public Token expectInteger(String message) throws IOException {
        return this.expect(message, Token::isInteger);
    }

    @Nonnull
    public Token expectLiteral(String message) throws IOException {
        return this.expect(message, Token::isStringLiteral);
    }

    public boolean hasNext() throws IOException {
        if (this.nextToken == null) {
            this.nextToken = this.nextInternal();
        }
        return this.nextToken != null;
    }

    public Token next() throws IOException {
        if (this.nextToken != null) {
            Token tmp = this.nextToken;
            this.nextToken = null;
            return tmp;
        }
        return this.nextInternal();
    }

    private Token nextStringLiteral(int startQuote) throws TokenizerException {
        int startOffset = this.readOffset;
        int startLinePos = this.linePos;
        int startLineNo = this.lineNo;
        boolean escaped = false;
        while (true) {
            int r;
            if ((r = this.read()) < 32 || r == 127) {
                int length = this.readOffset - startOffset;
                if (r == -1) {
                    throw this.failure(startLineNo, startLinePos, length, "Unexpected end of stream in literal", new Object[0]);
                }
                if (r == 10 || r == 13) {
                    throw this.failure(startLineNo, startLinePos, length - 1, "Unexpected line break in literal", new Object[0]);
                }
                throw this.failure(startLineNo, startLinePos, length + 1, "Unescaped non-printable char in literal: '%s'", Tokenizer.escapeChar(r));
            }
            if (escaped) {
                escaped = false;
                continue;
            }
            if (r == 92) {
                escaped = true;
                continue;
            }
            if (startQuote == r) break;
        }
        return this.token(startOffset, this.readOffset - startOffset + 1, startLinePos);
    }

    private Token nextInternal() throws IOException {
        int r;
        while ((r = this.read()) != -1) {
            if (r == 32 || r == 9 || r == 13 || r == 10) continue;
            if (r != 35) break;
            while ((r = this.read()) != -1 && r != 10 && r != 13) {
            }
        }
        if (r < 0) {
            return null;
        }
        if ("{}:=()<>,;#[]&/*|%$@^".indexOf(r) >= 0) {
            return this.nextSymbol(r);
        }
        if (r == 39 || r == 34) {
            return this.nextStringLiteral(r);
        }
        if (r == 46 || r == 45 || r >= 48 && r <= 57) {
            return this.nextNumber(r);
        }
        if (r == 95 || r >= 97 && r <= 122 || r >= 65 && r <= 90) {
            return this.nextIdentifier();
        }
        throw this.failure(this.lineNo, this.linePos, 1, "Unknown token initiator '%c'", r);
    }

    protected Token nextSymbol(int lastByte) throws TokenizerException {
        return this.token(this.readOffset, 1, this.linePos);
    }

    private Token nextNumber(int lastByte) throws TokenizerException {
        int startLinePos = this.linePos;
        int startLineNo = this.lineNo;
        int startOffset = this.readOffset;
        int len = 0;
        if (lastByte == 45) {
            lastByte = this.read();
            ++len;
            if (lastByte < 0) {
                throw this.failure(startLineNo, startLinePos, len, "Unexpected end of stream after negative indicator", new Object[0]);
            }
            if (lastByte != 46 && (lastByte < 48 || lastByte > 57)) {
                throw this.failure(startLineNo, startLinePos, len, "No decimal after negative indicator", new Object[0]);
            }
        } else if (lastByte == 48) {
            lastByte = this.read();
            ++len;
            if (lastByte == 120) {
                ++len;
                while ((lastByte = this.read()) != -1 && (lastByte >= 48 && lastByte <= 57 || lastByte >= 97 && lastByte <= 102 || lastByte >= 65 && lastByte <= 70)) {
                    ++len;
                }
                return this.validateAfterNumber(lastByte, startOffset, startLinePos, len);
            }
            if (48 <= lastByte && lastByte <= 55) {
                ++len;
                while ((lastByte = this.read()) != -1) {
                    if (lastByte >= 48 && lastByte <= 55) continue;
                    ++len;
                    break;
                }
                return this.validateAfterNumber(lastByte, startOffset, startLinePos, len);
            }
        }
        while (lastByte >= 48 && lastByte <= 57) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) continue;
        }
        if (lastByte == 46) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) {
                while (lastByte >= 48 && lastByte <= 57) {
                    ++len;
                    lastByte = this.read();
                    if (lastByte >= 0) continue;
                }
            }
        }
        if (lastByte == 101 || lastByte == 69) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) {
                if (lastByte == 45 || lastByte == 43) {
                    ++len;
                    lastByte = this.read();
                }
                if (lastByte < 48 || 57 < lastByte) {
                    throw this.failure(startLineNo, startLinePos, len + 1, "Missing exponent value", new Object[0]);
                }
                while (lastByte >= 48 && lastByte <= 57) {
                    ++len;
                    lastByte = this.read();
                    if (lastByte >= 0) continue;
                    break;
                }
            } else {
                throw this.failure(startLineNo, startLinePos, len, "Unexpected end of stream after exponent indicator", new Object[0]);
            }
        }
        return this.validateAfterNumber(lastByte, startOffset, startLinePos, len);
    }

    private Token validateAfterNumber(int lastByte, int startOffset, int startLinePos, int len) throws TokenizerException {
        if (lastByte < 0 || lastByte == 32 || lastByte == 9 || lastByte == 10 || lastByte == 13 || lastByte == 58 || lastByte == 125 || lastByte == 93 || lastByte == 41 || lastByte == 44 || lastByte == 59 || lastByte == 35) {
            if ("{}:=()<>,;#[]&/*|%$@^".indexOf(lastByte) >= 0) {
                this.unread();
            }
            return this.token(startOffset, len, startLinePos);
        }
        Token token = this.token(startOffset, ++len, startLinePos);
        throw this.failure(token, "Invalid termination of number: '%s'", Strings.escape((CharSequence)token.asString()));
    }

    private Token nextIdentifier() throws TokenizerException {
        int r;
        int startOffset = this.readOffset;
        int startLinePos = this.linePos;
        int startLineNo = this.lineNo;
        int len = 1;
        boolean dot = false;
        while ((r = this.read()) != -1) {
            if (r == 46) {
                ++len;
                if (dot) {
                    throw this.failure(startLineNo, startLinePos, len, "Identifier with double '.'", new Object[0]);
                }
                dot = true;
                continue;
            }
            if (dot) {
                if (!(r == 95 || r >= 97 && r <= 122 || r >= 65 && r <= 90)) {
                    if (r >= 48 && r <= 57) {
                        throw this.failure(startLineNo, startLinePos, len + 1, "Identifier part starting with digit '" + (char)r + "'", new Object[0]);
                    }
                    throw this.failure(startLineNo, startLinePos, len, "Identifier with trailing '.'", new Object[0]);
                }
                ++len;
                dot = false;
                continue;
            }
            if (r == 95 || r >= 48 && r <= 57 || r >= 97 && r <= 122 || r >= 65 && r <= 90) {
                ++len;
                continue;
            }
            this.unread();
            break;
        }
        if (r == -1 || r == 32 || r == 9 || r == 10 || r == 13 || "{}:=()<>,;#[]&/*|%$@^".indexOf(r) >= 0) {
            return this.token(startOffset, len, startLinePos);
        }
        throw this.failure(startLineNo, startLinePos, len, "Wrongly terminated identifier: '%s'", Tokenizer.escapeChar(r));
    }

    @Nonnull
    public String getLine(int theLine) {
        if (theLine < 1) {
            throw new IllegalArgumentException(theLine + " is not a valid line number. Must be 1 .. N");
        }
        int originalReadOffset = this.readOffset;
        int originalLineNo = this.lineNo;
        int originalLinePos = this.linePos;
        this.readOffset = -1;
        this.lineNo = 1;
        this.linePos = 0;
        try {
            int line = theLine;
            while (--line > 0) {
                int c;
                while ((c = this.read()) >= 0 && c != 10) {
                }
                if (c >= 0) continue;
                throw new IOException("No such line " + theLine);
            }
            String string = IOUtils.readString((Reader)this, (String)"\n");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        finally {
            this.readOffset = originalReadOffset;
            this.lineNo = originalLineNo;
            this.linePos = originalLinePos;
        }
    }

    public String readBinary(char end) throws IOException {
        int r;
        int startOffset = this.readOffset + 1;
        int startLinePos = this.linePos;
        int startLineNo = this.lineNo;
        while ((r = this.read()) != -1) {
            if (r == end) {
                return new CharSlice(this.buffer, startOffset, this.readOffset - startOffset).asString();
            }
            if (r != 32 && r != 9 && r != 10 && r != 13) continue;
            throw this.failure(startLineNo, startLinePos, this.linePos - startLinePos + 1, "Illegal char '%s' in binary", Tokenizer.escapeChar(r));
        }
        throw this.failure(startLineNo, startLinePos, this.linePos - startLinePos + 1, "unexpected end of stream in binary", new Object[0]);
    }

    @Nonnull
    public TokenizerException failure(Token token, String message, Object ... params) {
        return this.failure(token.getLineNo(), token.getLinePos(), token.length(), message, params);
    }

    @Nonnull
    protected TokenizerException failure(int startLineNo, int startLinePos, int length, String format, Object ... params) {
        return this.failure(format, params).setLineNo(startLineNo).setLinePos(startLinePos).setLine(this.getLine(startLineNo)).setLength(length);
    }

    @Nonnull
    protected TokenizerException failure(Throwable cause, int startLineNo, int startLinePos, int length, String message, Object ... params) {
        return this.failure(startLineNo, startLinePos, length, message, params).initCause(cause);
    }

    @Nonnull
    protected TokenizerException failure(String format, Object ... params) {
        return new TokenizerException(format, params);
    }

    @Nonnull
    protected Token token(int off, int len, int linePos) {
        return this.token(off, len, this.lineNo, linePos);
    }

    @Nonnull
    public Token token(int off, int len, int lineNo, int linePos) {
        return new Token(this.buffer, off, len, lineNo, linePos);
    }

    private static String escapeChar(int c) {
        return Strings.escape((CharSequence)new String(new char[]{(char)c}));
    }

    @FunctionalInterface
    public static interface TokenValidator {
        public boolean validate(Token var1);
    }
}

