/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.mio;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.streams.MessageStreams;

public class FileMessageWriter
implements MessageWriter {
    private final File file;
    private final Serializer serializer;
    private final boolean append;
    private OutputStream out;

    public FileMessageWriter(File file, Serializer serializer) {
        this(file, serializer, false);
    }

    public FileMessageWriter(File file, Serializer serializer, boolean append) {
        this.file = file;
        this.serializer = serializer;
        this.append = append;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int write(Message message) throws IOException {
        return this.serializer.serialize(this.getOutputStream(), message);
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int write(PServiceCall<Message, Field> call) throws IOException {
        return this.serializer.serialize(this.getOutputStream(), call);
    }

    @Override
    public int separator() throws IOException {
        if (!this.serializer.binaryProtocol()) {
            this.getOutputStream().write(MessageStreams.READABLE_ENTRY_SEP);
            return MessageStreams.READABLE_ENTRY_SEP.length;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                this.out.flush();
                this.out.close();
            }
            finally {
                this.out = null;
            }
        }
    }

    OutputStream getOutputStream() throws FileNotFoundException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(new FileOutputStream(this.file, this.append));
        }
        return this.out;
    }
}

