/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.mio.rolling;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import net.morimekta.providence.mio.RollingFileMessageWriter;
import net.morimekta.providence.mio.rolling.TimeBasedRollingPolicy;

public class TimeBasedCleanupPolicy
implements RollingFileMessageWriter.CleanupPolicy {
    private final String filePrefix;
    private final String fileSuffix;
    private final int units;
    private final TimeUnit resolution;
    private final DateTimeFormatter formatter;
    private final Clock clock;

    public TimeBasedCleanupPolicy(int units, TimeUnit resolution, String rollingFilePattern) {
        this(units, resolution, rollingFilePattern, Clock.systemDefaultZone());
    }

    public TimeBasedCleanupPolicy(int units, TimeUnit resolution, String rollingFilePattern, Clock clock) {
        Matcher matcher = TimeBasedRollingPolicy.FILE_PATTERN.matcher(rollingFilePattern);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("No timestamp input in rolling file pattern");
        }
        if (units < 1) {
            throw new IllegalArgumentException("Invalid duration: " + units);
        }
        this.filePrefix = matcher.group(1);
        this.fileSuffix = matcher.group(3);
        this.units = units;
        this.resolution = resolution;
        this.formatter = TimeBasedRollingPolicy.getFormatter(matcher.group(2), resolution);
        this.clock = clock;
    }

    @Override
    @Nonnull
    public List<String> getFilesToDelete(@Nonnull List<String> candidateFiles, @Nonnull String currentFileName) {
        LinkedList<String> out = new LinkedList<String>();
        ZonedDateTime removeBefore = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.clock.millis()), this.clock.getZone()).minusSeconds(this.resolution.toSeconds(this.units));
        for (String candidate : candidateFiles) {
            if (!candidate.startsWith(this.filePrefix) || !candidate.endsWith(this.fileSuffix) || candidate.length() <= this.filePrefix.length() + this.fileSuffix.length()) continue;
            try {
                String date = candidate.substring(this.filePrefix.length(), candidate.length() - this.fileSuffix.length());
                ZonedDateTime ts = ZonedDateTime.ofInstant(Instant.ofEpochMilli(LocalDateTime.parse(date, this.formatter).toInstant(ZoneOffset.UTC).toEpochMilli()), this.clock.getZone());
                if (!ts.isBefore(removeBefore)) continue;
                out.add(candidate);
            }
            catch (Exception exception) {}
        }
        return out;
    }
}

