/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PField;

public abstract class PMessageDescriptor<T extends PMessage<T, F>, F extends PField>
extends PDeclaredDescriptor<T> {
    private final Supplier<PMessageBuilder<T, F>> builderSupplier;
    private final boolean simple;

    public PMessageDescriptor(String programName, String name, Supplier<PMessageBuilder<T, F>> builderSupplier, boolean simple) {
        super(programName, name);
        this.builderSupplier = builderSupplier;
        this.simple = simple;
    }

    @Nonnull
    public abstract F[] getFields();

    @Nullable
    public abstract F findFieldByName(String var1);

    @Nullable
    public abstract F findFieldById(int var1);

    @Nonnull
    public F fieldForName(String name) {
        F field = this.findFieldByName(name);
        if (field == null) {
            throw new IllegalArgumentException("No field \"" + name + "\" in " + this.getQualifiedName());
        }
        return field;
    }

    @Nonnull
    public F fieldForId(int id) {
        F field = this.findFieldById(id);
        if (field == null) {
            throw new IllegalArgumentException("No field key " + id + " in " + this.getQualifiedName());
        }
        return field;
    }

    @Deprecated
    public F getField(String name) {
        return this.findFieldByName(name);
    }

    @Deprecated
    public F getField(int key) {
        return this.findFieldById(key);
    }

    public abstract PMessageVariant getVariant();

    public boolean isSimple() {
        return this.simple;
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.MESSAGE;
    }

    @Nonnull
    public PMessageBuilder<T, F> builder() {
        return this.builderSupplier.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        PMessageDescriptor other = (PMessageDescriptor)o;
        if (!this.getQualifiedName().equals(other.getQualifiedName()) || !this.getVariant().equals((Object)other.getVariant()) || this.getFields().length != other.getFields().length) {
            return false;
        }
        for (PField field : this.getFields()) {
            if (field.equals(other.findFieldById(field.getId()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.getClass(), this.getQualifiedName(), this.getVariant()});
        for (PField field : this.getFields()) {
            hash += Objects.hash(hash *= 28547, field.hashCode());
        }
        return hash;
    }

    protected Supplier<PMessageBuilder<T, F>> getBuilderSupplier() {
        return this.builderSupplier;
    }
}

