/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.util.BaseTypeRegistry;

public class SimpleTypeRegistry
extends BaseTypeRegistry {
    private final Map<String, PDeclaredDescriptor<?>> declaredTypes = new LinkedHashMap();
    private final Map<String, PService> services = new HashMap<String, PService>();
    private final Set<String> knownPrograms = new HashSet<String>();

    @Override
    @Nonnull
    public <T extends PDeclaredDescriptor<T>> T getDeclaredType(@Nonnull String typeName, @Nonnull String programContext) {
        String finalName = this.finalTypename(typeName, programContext);
        if (this.declaredTypes.containsKey(finalName)) {
            return (T)this.declaredTypes.get(finalName);
        }
        String program = finalName.replaceAll("\\..*", "");
        String name = finalName.replaceAll(".*\\.", "");
        if (this.knownPrograms.contains(program)) {
            throw new IllegalArgumentException("No such type \"" + name + "\" in program \"" + program + "\"");
        }
        throw new IllegalArgumentException("No such program \"" + program + "\" known for type \"" + typeName + "\"");
    }

    @Override
    @Nonnull
    public PService getService(String serviceName, String programContext) {
        String finalName = SimpleTypeRegistry.qualifiedNameFromIdAndContext(serviceName, programContext);
        if (this.services.containsKey(finalName)) {
            return this.services.get(finalName);
        }
        String program = finalName.replaceAll("\\..*", "");
        String name = finalName.replaceAll(".*\\.", "");
        if (this.knownPrograms.contains(program)) {
            throw new IllegalArgumentException("No such service \"" + name + "\" in program \"" + program + "\"");
        }
        throw new IllegalArgumentException("No such program \"" + program + "\" known for service \"" + serviceName + "\"");
    }

    @Override
    public boolean register(@Nonnull PService service) {
        String declaredTypeName = service.getQualifiedName();
        if (!this.services.containsKey(declaredTypeName)) {
            this.services.put(declaredTypeName, service);
            this.knownPrograms.add(service.getProgramName());
            return true;
        }
        return false;
    }

    @Override
    public <T> boolean register(PDeclaredDescriptor<T> declaredType) {
        String declaredTypeName = declaredType.getQualifiedName();
        if (this.declaredTypes.containsKey(declaredTypeName)) {
            return false;
        }
        this.declaredTypes.put(declaredTypeName, declaredType);
        this.knownPrograms.add(declaredType.getProgramName());
        return true;
    }
}

