/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;

public abstract class BaseSerializerProvider
implements SerializerProvider {
    private final Map<String, Serializer> serializerMap;
    private final String defaultMediaType;

    public BaseSerializerProvider(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
        this.serializerMap = new HashMap<String, Serializer>();
    }

    @Override
    @Nonnull
    public Serializer getSerializer(String mediaType) {
        Serializer serializer = this.serializerMap.get(mediaType);
        if (serializer == null) {
            throw new IllegalArgumentException("No such serializer for media type " + mediaType);
        }
        return serializer;
    }

    @Override
    @Nonnull
    public Serializer getDefault() {
        return this.getSerializer(this.defaultMediaType);
    }

    protected void register(Serializer serializer, String ... mediaTypes) {
        for (String mediaType : mediaTypes) {
            this.serializerMap.put(mediaType, serializer);
        }
    }
}

