/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.util.ThriftAnnotation;
import net.morimekta.providence.util.ThriftCollection;
import net.morimekta.providence.util.WritableTypeRegistry;

public abstract class BaseTypeRegistry
implements WritableTypeRegistry {
    private final Map<String, String> typedefs = new HashMap<String, String>();

    protected BaseTypeRegistry() {
    }

    @Override
    public void registerTypedef(@Nonnull String identifier, @Nonnull String programContext, @Nonnull String target) {
        this.typedefs.put(BaseTypeRegistry.qualifiedNameFromIdAndContext(identifier, programContext), this.finalTypename(target, programContext));
    }

    @Override
    public PDescriptorProvider getProvider(String name, String context, Map<String, String> annotations) {
        String itemType;
        PPrimitive primitive = PPrimitive.findByName(name = this.finalTypename(name, context));
        if (primitive != null) {
            return primitive.provider();
        }
        if (annotations == null) {
            annotations = Collections.EMPTY_MAP;
        }
        if (name.startsWith("map<") && name.endsWith(">")) {
            String[] parts = name.substring(4, name.length() - 1).split(",", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(name + " is not a valid map descriptor, wrong number of types.");
            }
            String keyType = parts[0];
            String valueType = parts[1];
            switch (ThriftCollection.forName((String)annotations.get(ThriftAnnotation.CONTAINER.tag))) {
                case SORTED: {
                    return PMap.sortedProvider(this.getProvider(keyType, context, null), this.getProvider(valueType, context, null));
                }
                case ORDERED: {
                    return PMap.orderedProvider(this.getProvider(keyType, context, null), this.getProvider(valueType, context, null));
                }
                case DEFAULT: {
                    return PMap.provider(this.getProvider(keyType, context, null), this.getProvider(valueType, context, null));
                }
            }
        }
        if (name.startsWith("set<") && name.endsWith(">")) {
            itemType = name.substring(4, name.length() - 1);
            switch (ThriftCollection.forName((String)annotations.get(ThriftAnnotation.CONTAINER.tag))) {
                case SORTED: {
                    return PSet.sortedProvider(this.getProvider(itemType, context, null));
                }
                case ORDERED: {
                    return PSet.orderedProvider(this.getProvider(itemType, context, null));
                }
                case DEFAULT: {
                    return PSet.provider(this.getProvider(itemType, context, null));
                }
            }
        }
        if (name.startsWith("list<") && name.endsWith(">")) {
            itemType = name.substring(5, name.length() - 1);
            return PList.provider(this.getProvider(itemType, context, null));
        }
        if (name.split("[.]").length != 2) {
            throw new IllegalArgumentException(name + " is not a valid declared type identifier.");
        }
        String finalName = name;
        return () -> this.getDeclaredType(finalName, context);
    }

    @Override
    public PServiceProvider getServiceProvider(String serviceName, String programContext) {
        return () -> this.getService(serviceName, programContext);
    }

    @Override
    public void registerRecursively(@Nonnull PService service) {
        if (this.register(service) && service.getExtendsService() != null) {
            this.registerRecursively(service.getExtendsService());
        }
    }

    @Override
    public <T> void registerRecursively(PDeclaredDescriptor<T> declaredType) {
        if (this.register(declaredType) && declaredType instanceof PMessageDescriptor) {
            PMessageDescriptor descriptor = (PMessageDescriptor)declaredType;
            for (PField field : descriptor.getFields()) {
                if (field.getType() == PType.ENUM || field.getType() == PType.MESSAGE) {
                    this.registerRecursively((PDeclaredDescriptor)field.getDescriptor());
                    continue;
                }
                if (field.getType() != PType.MAP && field.getType() != PType.LIST && field.getType() != PType.SET) continue;
                this.registerListType((PContainer)field.getDescriptor());
            }
        }
    }

    protected String finalTypename(String typeName, String programContext) {
        String qualifiedName = this.qualifiedTypenameInternal(typeName, programContext);
        if (this.typedefs.containsKey(qualifiedName)) {
            String resolved = this.typedefs.get(qualifiedName);
            return this.finalTypename(resolved, programContext);
        }
        return qualifiedName;
    }

    protected static String qualifiedNameFromIdAndContext(String name, String context) {
        if (!name.contains(".")) {
            return context + "." + name;
        }
        return name;
    }

    private void registerListType(PContainer containerType) {
        PDescriptor keyType;
        PDescriptor itemType = containerType.itemDescriptor();
        if (itemType.getType() == PType.MAP || itemType.getType() == PType.LIST || itemType.getType() == PType.SET) {
            this.registerListType((PContainer)itemType);
        } else if (itemType.getType() == PType.ENUM || itemType.getType() == PType.MESSAGE) {
            this.registerRecursively((PDeclaredDescriptor)itemType);
        }
        if (containerType instanceof PMap && ((keyType = containerType.itemDescriptor()).getType() == PType.ENUM || keyType.getType() == PType.MESSAGE)) {
            this.registerRecursively((PDeclaredDescriptor)keyType);
        }
    }

    @Nonnull
    private String qualifiedTypenameInternal(@Nonnull String typeName, @Nonnull String programContext) {
        if (PPrimitive.findByName(typeName) != null) {
            return typeName;
        }
        if (typeName.startsWith("map<") && typeName.endsWith(">")) {
            String[] generic = typeName.substring(4, typeName.length() - 1).split(",");
            if (generic.length != 2) {
                throw new IllegalArgumentException("Invalid map generic part: \"" + typeName + "\"");
            }
            return "map<" + this.finalTypename(generic[0].trim(), programContext) + "," + this.finalTypename(generic[1].trim(), programContext) + ">";
        }
        if (typeName.startsWith("set<") && typeName.endsWith(">")) {
            String generic = typeName.substring(4, typeName.length() - 1);
            return "set<" + this.finalTypename(generic.trim(), programContext) + ">";
        }
        if (typeName.startsWith("list<") && typeName.endsWith(">")) {
            String generic = typeName.substring(5, typeName.length() - 1);
            return "list<" + this.finalTypename(generic.trim(), programContext) + ">";
        }
        return BaseTypeRegistry.qualifiedNameFromIdAndContext(typeName, programContext);
    }
}

