/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;

public interface TypeRegistry {
    @Nonnull
    public <T extends PDeclaredDescriptor<T>> T getDeclaredType(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    default public <T extends PDeclaredDescriptor<T>> T getDeclaredType(@Nonnull String typeName) {
        String[] parts = typeName.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Requesting global type name without program name: \"" + typeName + "\"");
        }
        if (parts.length > 2) {
            throw new IllegalArgumentException("Invalid identifier: \"" + typeName + "\"");
        }
        return this.getDeclaredType(parts[1], parts[0]);
    }

    @Nonnull
    public PService getService(String var1, String var2);

    @Nonnull
    default public PService getService(String serviceName) {
        String[] parts = serviceName.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Requesting global service name without package: \"" + serviceName + "\"");
        }
        if (parts.length > 2) {
            throw new IllegalArgumentException("Invalid identifier: \"" + serviceName + "\"");
        }
        return this.getService(parts[1], parts[0]);
    }

    public PDescriptorProvider getProvider(String var1, String var2, Map<String, String> var3);

    public PServiceProvider getServiceProvider(String var1, String var2);
}

