/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.pretty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.io.File;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.pretty.Token;

public class TokenizerException
extends SerializerException {
    private int lineNo;
    private int linePos;
    private String line;
    private String file;
    private int length;

    public TokenizerException(TokenizerException e, File file) {
        super(e.getMessage(), new Object[0]);
        this.initCause(e);
        this.setLine(e.getLine());
        this.setLineNo(e.getLineNo());
        this.setLinePos(e.getLinePos());
        this.setLength(e.getLength());
        if (e.getFile() == null && file != null) {
            this.setFile(file.getName());
        } else {
            this.setFile(e.getFile());
        }
    }

    public TokenizerException(String format, Object ... args) {
        super(format, args);
    }

    public TokenizerException(Throwable cause, String format, Object ... args) {
        super(cause, format, args);
    }

    public TokenizerException(Token token, String format, Object ... args) {
        super(format, args);
        this.setLinePos(token.getLinePos());
        this.setLineNo(token.getLineNo());
        this.setLength(token.asString().length());
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public int getLength() {
        return this.length;
    }

    public String getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public TokenizerException setLineNo(int lineNo) {
        this.lineNo = lineNo;
        return this;
    }

    public TokenizerException setLinePos(int linePos) {
        this.linePos = linePos;
        return this;
    }

    public TokenizerException setLength(int len) {
        this.length = len;
        return this;
    }

    public TokenizerException setLine(String line) {
        this.line = line;
        return this;
    }

    public TokenizerException setFile(String file) {
        this.file = file;
        return this;
    }

    @Override
    public TokenizerException initCause(Throwable cause) {
        return (TokenizerException)super.initCause(cause);
    }

    @Override
    public String asString() {
        if (this.lineNo > 0) {
            String fileSpec = "";
            if (this.file != null) {
                fileSpec = " in " + this.file;
            }
            if (this.line != null) {
                return String.format("Error%s on line %d, pos %d: %s%n%s%n%s%s", fileSpec, this.getLineNo(), this.getLinePos(), this.getMessage(), this.getLine(), net.morimekta.util.Strings.times((String)"-", (int)(this.linePos - 1)), net.morimekta.util.Strings.times((String)"^", (int)Math.max(1, this.length)));
            }
            return String.format("Error%s on line %d, pos %d: %s", fileSpec, this.getLineNo(), this.getLinePos(), this.getMessage());
        }
        return String.format("Error: %s", this.getMessage());
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this.getClass()).omitNullValues().addValue((Object)this.getMessage()).add("file", (Object)this.file);
        if (this.getExceptionType() != PApplicationExceptionType.PROTOCOL_ERROR) {
            helper.add("e", (Object)this.getExceptionType());
        }
        if (!Strings.isNullOrEmpty((String)this.getLine())) {
            helper.add("line", this.lineNo);
            helper.add("pos", this.linePos);
            helper.add("len", this.length);
        }
        if (!Strings.isNullOrEmpty((String)this.getMethodName())) {
            helper.add("method", (Object)this.getMethodName());
            helper.add("type", (Object)this.getCallType());
            helper.add("seq", this.getSequenceNo());
        }
        return helper.toString();
    }
}

