/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;

public class TypeRegistry {
    private final Map<String, PDeclaredDescriptor<?>> declaredTypes;
    private final HashSet<String> knownPrograms = new HashSet();
    private final Map<String, String> typedefs;
    private final Map<String, PService> services;

    public TypeRegistry() {
        this.declaredTypes = new LinkedHashMap();
        this.typedefs = new HashMap<String, String>();
        this.services = new HashMap<String, PService>();
    }

    @Nonnull
    public <T extends PDeclaredDescriptor<T>> T getDeclaredType(@Nonnull String name, @Nonnull String context) {
        String declaredTypeName = this.finalTypename(name, context);
        context = declaredTypeName.replaceAll("\\..*", "");
        name = declaredTypeName.replaceAll(".*\\.", "");
        if (this.declaredTypes.containsKey(declaredTypeName)) {
            return (T)this.declaredTypes.get(declaredTypeName);
        }
        if (this.knownPrograms.contains(context)) {
            throw new IllegalArgumentException("No such type \"" + name + "\" in package \"" + context + "\"");
        }
        throw new IllegalArgumentException("No such package \"" + context + "\" exists for type \"" + name + "\"");
    }

    @Nonnull
    public <T extends PDeclaredDescriptor<T>> T getDeclaredType(@Nonnull String name) {
        String[] parts = name.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Requesting global typename without package: \"" + name + "\"");
        }
        if (parts.length > 2) {
            throw new IllegalArgumentException("Invalid declared type: \"" + name + "\"");
        }
        return this.getDeclaredType(parts[1], parts[0]);
    }

    public <T> void putDeclaredType(@Nonnull PDeclaredDescriptor<T> declaredType) {
        String declaredTypeName = declaredType.getQualifiedName();
        if (this.declaredTypes.containsKey(declaredTypeName)) {
            throw new IllegalStateException("Type " + declaredTypeName + " already exists");
        }
        this.knownPrograms.add(declaredType.getProgramName());
        this.declaredTypes.put(declaredTypeName, declaredType);
    }

    public void putService(PService service) {
        if (service == null) {
            throw new IllegalArgumentException("No service to register");
        }
        String name = service.getQualifiedName();
        if (this.services.containsKey(name)) {
            throw new IllegalStateException("Service " + name + " already registered");
        }
        this.services.put(name, service);
    }

    @Nullable
    public PService getService(String name, String context) {
        return this.services.get(TypeRegistry.qualifiedName(name, context));
    }

    public <T> void registerRecursively(PDeclaredDescriptor<T> declaredType) {
        String declaredTypeName = declaredType.getQualifiedName();
        if (this.declaredTypes.containsKey(declaredTypeName)) {
            return;
        }
        this.putDeclaredType(declaredType);
        if (declaredType instanceof PMessageDescriptor) {
            PMessageDescriptor descriptor = (PMessageDescriptor)declaredType;
            for (PField field : descriptor.getFields()) {
                if (field.getType() == PType.ENUM || field.getType() == PType.MESSAGE) {
                    this.registerRecursively((PDeclaredDescriptor)field.getDescriptor());
                    continue;
                }
                if (field.getType() != PType.MAP && field.getType() != PType.LIST && field.getType() != PType.SET) continue;
                this.registerListType((PContainer)field.getDescriptor());
            }
        }
    }

    public void putTypedef(String identifier, String context, String target) {
        if (identifier == null || context == null || target == null) {
            throw new IllegalArgumentException("Null argument to putTypedef");
        }
        identifier = this.qualifiedTypename(identifier, context);
        target = this.qualifiedTypename(target, context);
        this.typedefs.put(identifier, target);
    }

    protected String finalTypename(String name, String context) {
        String typename = this.qualifiedTypename(name, context);
        if (this.typedefs.containsKey(typename)) {
            typename = this.typedefs.get(typename);
            return this.finalTypename(typename, context);
        }
        return typename;
    }

    @Nonnull
    private String qualifiedTypename(String name, String context) {
        if (name == null || context == null) {
            throw new IllegalArgumentException("Null argument for qualified typename");
        }
        if (PPrimitive.findByName(name) != null) {
            return name;
        }
        if (name.startsWith("map<") && name.endsWith(">")) {
            String[] generic = name.substring(4, name.length() - 1).split(",");
            if (generic.length != 2) {
                throw new IllegalArgumentException();
            }
            return "map<" + this.finalTypename(generic[0].trim(), context) + "," + this.finalTypename(generic[1].trim(), context) + ">";
        }
        if (name.startsWith("set<") && name.endsWith(">")) {
            String generic = name.substring(4, name.length() - 1);
            return "set<" + this.finalTypename(generic.trim(), context) + ">";
        }
        if (name.startsWith("list<") && name.endsWith(">")) {
            String generic = name.substring(5, name.length() - 1);
            return "list<" + this.finalTypename(generic.trim(), context) + ">";
        }
        return TypeRegistry.qualifiedName(name, context);
    }

    private void registerListType(PContainer containerType) {
        PDescriptor keyType;
        PDescriptor itemType = containerType.itemDescriptor();
        if (itemType.getType() == PType.MAP || itemType.getType() == PType.LIST || itemType.getType() == PType.SET) {
            this.registerListType((PContainer)itemType);
        } else if (itemType.getType() == PType.ENUM || itemType.getType() == PType.MESSAGE) {
            this.registerRecursively((PDeclaredDescriptor)itemType);
        }
        if (containerType instanceof PMap && ((keyType = containerType.itemDescriptor()).getType() == PType.ENUM || keyType.getType() == PType.MESSAGE)) {
            this.registerRecursively((PDeclaredDescriptor)keyType);
        }
    }

    private static String qualifiedName(String name, String context) {
        if (!name.contains(".")) {
            return context + "." + name;
        }
        return name;
    }
}

