/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.streams;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.streams.MessageSpliterator;

public class MessageStreams {
    @SuppressFBWarnings(justification="We need this constant some place anyway, andjava does still not support truly const arrays.", value={"MS_MUTABLE_ARRAY"})
    public static final byte[] READABLE_ENTRY_SEP = new byte[]{10};

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Stream<Message> path(Path file, Serializer serializer, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        return MessageStreams.file(file.toFile(), serializer, descriptor);
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Stream<Message> file(File file, Serializer serializer, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return MessageStreams.stream(in, serializer, descriptor);
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Stream<Message> resource(@Nonnull String resource, @Nonnull Serializer serializer, @Nonnull PMessageDescriptor<Message, Field> descriptor) throws IOException {
        InputStream in = MessageStreams.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("No such resource " + resource);
        }
        in = new BufferedInputStream(in);
        return MessageStreams.stream(in, serializer, descriptor);
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Stream<Message> stream(InputStream in, Serializer serializer, PMessageDescriptor<Message, Field> descriptor) {
        return StreamSupport.stream(new MessageSpliterator<Message, Field>(in, serializer, descriptor), false);
    }
}

