/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.streams.MessageStreams;

public class ProvidenceHelper {
    private static final PrettySerializer DEBUG_STRING_SERIALIZER = new PrettySerializer().debug();

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message fromJsonResource(String path, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        return ProvidenceHelper.fromResource(path, descriptor, new JsonSerializer(true));
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> ArrayList<Message> arrayListFromJsonResource(String path, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        return ProvidenceHelper.arrayListFromResource(path, descriptor, new JsonSerializer(true));
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message fromResource(String resource, PMessageDescriptor<Message, Field> descriptor, Serializer serializer) throws IOException {
        InputStream in = ProvidenceHelper.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("No such resource " + resource);
        }
        return serializer.deserialize((InputStream)new BufferedInputStream(in), descriptor);
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> ArrayList<Message> arrayListFromResource(String path, PMessageDescriptor<Message, Field> descriptor, Serializer serializer) throws IOException {
        return MessageStreams.resource(path, serializer, descriptor).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> String debugString(Message message) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEBUG_STRING_SERIALIZER.serialize((OutputStream)baos, message);
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message parseDebugString(String string, PMessageDescriptor<Message, Field> descriptor) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            return DEBUG_STRING_SERIALIZER.deserialize((InputStream)bais, descriptor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ProvidenceHelper() {
    }
}

