/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.streams;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.streams.MessageStreams;
import net.morimekta.util.io.IOUtils;

public class MessageSpliterator<Message extends PMessage<Message, Field>, Field extends PField>
implements Spliterator<Message> {
    private final InputStream in;
    private final PMessageDescriptor<Message, Field> descriptor;
    private final Serializer serializer;
    private int num;
    private Closeable closer;

    public MessageSpliterator(@Nonnull InputStream in, @Nonnull Serializer serializer, @Nonnull PMessageDescriptor<Message, Field> descriptor) {
        this(in, serializer, descriptor, in);
    }

    public MessageSpliterator(@Nonnull InputStream in, @Nonnull Serializer serializer, @Nonnull PMessageDescriptor<Message, Field> descriptor, @Nullable Closeable closer) {
        this.in = in;
        this.serializer = serializer;
        this.descriptor = descriptor;
        this.closer = closer;
        this.num = 0;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Message> action) {
        Message message = this.read();
        if (message != null) {
            action.accept(message);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<Message> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getExactSizeIfKnown() {
        return -1L;
    }

    @Override
    public int characteristics() {
        return 1296;
    }

    @Override
    public Comparator<? super Message> getComparator() {
        return Comparable::compareTo;
    }

    private Message read() {
        try {
            if (this.num > 0 && !this.serializer.binaryProtocol() && !IOUtils.skipUntil((InputStream)this.in, (byte[])MessageStreams.READABLE_ENTRY_SEP)) {
                Message Message = this.close(null);
                return Message;
            }
            if (this.in.markSupported()) {
                this.in.mark(2);
                if (this.in.read() < 0) {
                    Message Message = this.close(null);
                    return Message;
                }
                this.in.reset();
            }
            Message Message = this.serializer.deserialize(this.in, this.descriptor);
            return Message;
        }
        catch (IOException e) {
            this.close(e);
            throw new UncheckedIOException(e);
        }
        finally {
            ++this.num;
        }
    }

    private Message close(Exception cause) {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (IOException e) {
                if (cause == null) {
                    throw new UncheckedIOException(e);
                }
                cause.addSuppressed(e);
            }
            finally {
                this.closer = null;
            }
        }
        return null;
    }
}

