/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.streams;

import com.google.common.base.Suppliers;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collector;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.streams.MessageStreams;

public class MessageCollectors {
    public static <Message extends PMessage<Message, Field>, Field extends PField> Collector<Message, OutputStream, Integer> toPath(Path file, Serializer serializer) {
        return MessageCollectors.toFile(file.toFile(), serializer);
    }

    public static <Message extends PMessage<Message, Field>, Field extends PField> Collector<Message, OutputStream, Integer> toFile(File file, Serializer serializer) {
        AtomicInteger result = new AtomicInteger(0);
        return Collector.of(Suppliers.memoize(() -> {
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to open " + file.getName(), e);
            }
        }), (outputStream, t) -> {
            try {
                AtomicInteger atomicInteger = result;
                synchronized (atomicInteger) {
                    result.addAndGet(serializer.serialize((OutputStream)outputStream, t));
                    if (!serializer.binaryProtocol()) {
                        result.addAndGet(MessageCollectors.maybeWriteBytes(outputStream, MessageStreams.READABLE_ENTRY_SEP));
                    }
                }
            }
            catch (SerializerException e) {
                throw new UncheckedIOException("Bad data", e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to write to " + file.getName(), e);
            }
        }, (a, b) -> a, outputStream -> {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to close " + file.getName(), e);
            }
            return result.getAndSet(0);
        }, new Collector.Characteristics[0]);
    }

    public static <Message extends PMessage<Message, Field>, Field extends PField> Collector<Message, AtomicInteger, Integer> toStream(OutputStream out, Serializer serializer) {
        return Collector.of(AtomicInteger::new, (counter, t) -> {
            try {
                OutputStream outputStream = out;
                synchronized (outputStream) {
                    counter.addAndGet(serializer.serialize(out, t));
                    if (!serializer.binaryProtocol()) {
                        counter.addAndGet(MessageCollectors.maybeWriteBytes(out, MessageStreams.READABLE_ENTRY_SEP));
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, (a, b) -> {
            a.addAndGet(b.get());
            return a;
        }, AtomicInteger::get, new Collector.Characteristics[0]);
    }

    private static int maybeWriteBytes(OutputStream out, byte[] bytes) throws IOException {
        if (bytes.length > 0) {
            out.write(bytes);
        }
        return bytes.length;
    }

    private MessageCollectors() {
    }
}

