/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.rw;

import javax.annotation.Nonnull;
import net.morimekta.providence.PType;

public class BinaryType {
    public static final byte STOP = 0;
    public static final byte VOID = 1;
    public static final byte BOOL = 2;
    public static final byte BYTE = 3;
    public static final byte DOUBLE = 4;
    public static final byte I16 = 6;
    public static final byte I32 = 8;
    public static final byte I64 = 10;
    public static final byte STRING = 11;
    public static final byte STRUCT = 12;
    public static final byte MAP = 13;
    public static final byte SET = 14;
    public static final byte LIST = 15;

    public static byte forType(@Nonnull PType type) {
        switch (type) {
            case VOID: {
                return 1;
            }
            case BOOL: {
                return 2;
            }
            case BYTE: {
                return 3;
            }
            case I16: {
                return 6;
            }
            case I32: {
                return 8;
            }
            case I64: {
                return 10;
            }
            case DOUBLE: {
                return 4;
            }
            case STRING: {
                return 11;
            }
            case BINARY: {
                return 11;
            }
            case ENUM: {
                return 8;
            }
            case MAP: {
                return 13;
            }
            case SET: {
                return 14;
            }
            case LIST: {
                return 15;
            }
            case MESSAGE: {
                return 12;
            }
        }
        throw new IllegalArgumentException("Unknown binary type for " + type.toString());
    }

    public static String asString(byte id) {
        switch (id) {
            case 0: {
                return "stop(0)";
            }
            case 1: {
                return "void(1)";
            }
            case 2: {
                return "bool(2)";
            }
            case 3: {
                return "byte(3)";
            }
            case 4: {
                return "double(4)";
            }
            case 6: {
                return "i16(6)";
            }
            case 8: {
                return "i32(8)";
            }
            case 10: {
                return "i64(10)";
            }
            case 11: {
                return "string(11)";
            }
            case 12: {
                return "struct(12)";
            }
            case 13: {
                return "map(13)";
            }
            case 14: {
                return "set(14)";
            }
            case 15: {
                return "list(15)";
            }
        }
        return "unknown(" + id + ")";
    }

    private BinaryType() {
    }
}

