/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Binary;
import net.morimekta.util.io.LittleEndianBinaryReader;
import net.morimekta.util.io.LittleEndianBinaryWriter;

public class FastBinarySerializer
extends Serializer {
    public static final String MIME_TYPE = "application/vnd.morimekta.providence.binary";
    private final boolean readStrict;
    private static final int STOP = 0;
    private static final int NONE = 1;
    private static final int TRUE = 2;
    private static final int VARINT = 3;
    private static final int FIXED_64 = 4;
    private static final int BINARY = 5;
    private static final int MESSAGE = 6;
    private static final int COLLECTION = 7;

    public FastBinarySerializer() {
        this(false);
    }

    public FastBinarySerializer(boolean readStrict) {
        this.readStrict = readStrict;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream os, Message message) throws IOException {
        LittleEndianBinaryWriter out = new LittleEndianBinaryWriter(os);
        return this.writeMessage(out, message);
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream os, PServiceCall<Message, Field> call) throws IOException {
        LittleEndianBinaryWriter out = new LittleEndianBinaryWriter(os);
        byte[] method = call.getMethod().getBytes(StandardCharsets.UTF_8);
        int len = out.writeVarint(method.length << 3 | call.getType().getValue());
        len += method.length;
        out.write(method);
        len += out.writeVarint(call.getSequence());
        return len += this.writeMessage(out, call.getMessage());
    }

    @Override
    @Nonnull
    public <Message extends PMessage<Message, Field>, Field extends PField> Message deserialize(InputStream is, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        LittleEndianBinaryReader in = new LittleEndianBinaryReader(is);
        return this.readMessage(in, descriptor);
    }

    @Override
    @Nonnull
    public <Message extends PMessage<Message, Field>, Field extends PField> PServiceCall<Message, Field> deserialize(InputStream is, PService service) throws SerializerException {
        String methodName = null;
        int sequence = 0;
        PServiceCallType type = null;
        try {
            LittleEndianBinaryReader in = new LittleEndianBinaryReader(is);
            int tag = in.readIntVarint();
            int len = tag >>> 3;
            int typeKey = tag & 7;
            methodName = new String(in.expectBytes(len), StandardCharsets.UTF_8);
            sequence = in.readIntVarint();
            type = PServiceCallType.forValue(typeKey);
            if (type == null) {
                throw new SerializerException("Invalid call type " + typeKey, new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            if (type == PServiceCallType.EXCEPTION) {
                PApplicationException ex = this.readMessage(in, PApplicationException.kDescriptor);
                return new PServiceCall(methodName, type, sequence, ex);
            }
            PServiceMethod method = service.getMethod(methodName);
            if (method == null) {
                throw new SerializerException("No such method %s on %s", methodName, service.getQualifiedName()).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            PMessageDescriptor descriptor = this.isRequestCallType(type) ? method.getRequestType() : method.getResponseType();
            Message message = this.readMessage(in, descriptor);
            return new PServiceCall(methodName, type, sequence, message);
        }
        catch (SerializerException e) {
            throw new SerializerException(e).setCallType(type).setMethodName(methodName).setSequenceNo(sequence);
        }
        catch (IOException e) {
            throw new SerializerException(e, e.getMessage(), new Object[0]).setCallType(type).setMethodName(methodName).setSequenceNo(sequence);
        }
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String mimeType() {
        return MIME_TYPE;
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> int writeMessage(LittleEndianBinaryWriter out, Message message) throws IOException {
        int len = 0;
        if (message instanceof PUnion) {
            Object field = ((PUnion)message).unionField();
            if (field != null) {
                len += this.writeFieldValue(out, field.getKey(), field.getDescriptor(), message.get(field.getKey()));
            }
        } else {
            for (PField field : message.descriptor().getFields()) {
                if (!message.has(field.getKey())) continue;
                len += this.writeFieldValue(out, field.getKey(), field.getDescriptor(), message.get(field.getKey()));
            }
        }
        return len + out.writeVarint(0);
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message readMessage(LittleEndianBinaryReader in, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        int tag;
        if (descriptor == null) {
            int tag2;
            while ((tag2 = in.readIntVarint()) != 0) {
                int type = tag2 & 7;
                this.readFieldValue(in, type, null);
            }
            return null;
        }
        PBuilder builder = descriptor.builder();
        while ((tag = in.readIntVarint()) != 0) {
            int id = tag >>> 3;
            int type = tag & 7;
            Field field = descriptor.getField(id);
            if (field != null) {
                Object value = this.readFieldValue(in, type, field.getDescriptor());
                ((PMessageBuilder)builder).set(field.getKey(), value);
                continue;
            }
            this.readFieldValue(in, type, null);
        }
        if (this.readStrict) {
            try {
                ((PMessageBuilder)builder).validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException(e, e.getMessage(), new Object[0]);
            }
        }
        return (Message)((PMessage)builder.build());
    }

    private int writeFieldValue(LittleEndianBinaryWriter out, int key, PDescriptor descriptor, Object value) throws IOException {
        switch (descriptor.getType()) {
            case VOID: {
                return out.writeVarint(key << 3 | 2);
            }
            case BOOL: {
                return out.writeVarint(key << 3 | ((Boolean)value != false ? 2 : 1));
            }
            case BYTE: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag((int)((Byte)value).byteValue());
            }
            case I16: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag((int)((Short)value).shortValue());
            }
            case I32: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag(((Integer)value).intValue());
            }
            case I64: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag(((Long)value).longValue());
            }
            case DOUBLE: {
                int len = out.writeVarint(key << 3 | 4);
                return len + out.writeDouble(((Double)value).doubleValue());
            }
            case STRING: {
                byte[] bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                int len = out.writeVarint(key << 3 | 5);
                out.write(bytes);
                return (len += out.writeVarint(bytes.length)) + bytes.length;
            }
            case BINARY: {
                Binary bytes = (Binary)value;
                int len = out.writeVarint(key << 3 | 5);
                bytes.write((OutputStream)out);
                return (len += out.writeVarint(bytes.length())) + bytes.length();
            }
            case ENUM: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag(((PEnumValue)value).getValue());
            }
            case MESSAGE: {
                int len = out.writeVarint(key << 3 | 6);
                return len + this.writeMessage(out, (PMessage)value);
            }
            case MAP: 
            case SET: 
            case LIST: {
                int len = out.writeVarint(key << 3 | 7);
                return len + this.writeContainerEntry(out, 7, descriptor, value);
            }
        }
        throw new Error("Unreachable code reached");
    }

    private int writeContainerEntry(LittleEndianBinaryWriter out, int typeid, PDescriptor descriptor, Object value) throws IOException {
        switch (typeid) {
            case 3: {
                if (value instanceof Boolean) {
                    return out.writeVarint((Boolean)value != false ? 1 : 0);
                }
                if (value instanceof Number) {
                    return out.writeZigzag(((Number)value).longValue());
                }
                if (value instanceof PEnumValue) {
                    return out.writeZigzag(((PEnumValue)value).getValue());
                }
                throw new SerializerException("", new Object[0]);
            }
            case 4: {
                return out.writeDouble(((Double)value).doubleValue());
            }
            case 5: {
                if (value instanceof CharSequence) {
                    byte[] bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                    int len = out.writeVarint(bytes.length);
                    out.write(bytes);
                    return len + bytes.length;
                }
                if (value instanceof Binary) {
                    Binary bytes = (Binary)value;
                    int len = out.writeVarint(bytes.length());
                    bytes.write((OutputStream)out);
                    return len + bytes.length();
                }
                throw new SerializerException("", new Object[0]);
            }
            case 6: {
                return this.writeMessage(out, (PMessage)value);
            }
            case 7: {
                if (value instanceof Map) {
                    Map map = (Map)value;
                    PMap desc = (PMap)descriptor;
                    int ktype = FastBinarySerializer.itemType(desc.keyDescriptor());
                    int vtype = FastBinarySerializer.itemType(desc.itemDescriptor());
                    int len = out.writeVarint(map.size() * 2);
                    len += out.writeVarint(ktype << 3 | vtype);
                    for (Map.Entry entry : map.entrySet()) {
                        len += this.writeContainerEntry(out, ktype, desc.keyDescriptor(), entry.getKey());
                        len += this.writeContainerEntry(out, vtype, desc.itemDescriptor(), entry.getValue());
                    }
                    return len;
                }
                if (value instanceof Collection) {
                    Collection coll = (Collection)value;
                    PContainer desc = (PContainer)descriptor;
                    int vtype = FastBinarySerializer.itemType(desc.itemDescriptor());
                    int len = out.writeVarint(coll.size());
                    len += out.writeVarint(vtype);
                    for (Object item : coll) {
                        len += this.writeContainerEntry(out, vtype, desc.itemDescriptor(), item);
                    }
                    return len;
                }
                throw new SerializerException("", new Object[0]);
            }
        }
        throw new SerializerException("", new Object[0]);
    }

    private Object readFieldValue(LittleEndianBinaryReader in, int type, PDescriptor descriptor) throws IOException {
        switch (type) {
            case 1: {
                return Boolean.FALSE;
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 3: {
                if (descriptor == null) {
                    in.readLongVarint();
                    return null;
                }
                switch (descriptor.getType()) {
                    case BOOL: {
                        return in.readIntVarint() != 0;
                    }
                    case BYTE: {
                        return (byte)in.readIntZigzag();
                    }
                    case I16: {
                        return (short)in.readIntZigzag();
                    }
                    case I32: {
                        return in.readIntZigzag();
                    }
                    case I64: {
                        return in.readLongZigzag();
                    }
                    case ENUM: {
                        PBuilder builder = ((PEnumDescriptor)descriptor).builder();
                        ((PEnumBuilder)builder).setByValue(in.readIntZigzag());
                        return builder.build();
                    }
                }
                throw new SerializerException("", new Object[0]);
            }
            case 4: {
                return in.expectDouble();
            }
            case 5: {
                int len = in.readIntVarint();
                byte[] data = in.expectBytes(len);
                if (descriptor != null) {
                    switch (descriptor.getType()) {
                        case STRING: {
                            return new String(data, StandardCharsets.UTF_8);
                        }
                        case BINARY: {
                            return Binary.wrap((byte[])data);
                        }
                    }
                    throw new SerializerException("", new Object[0]);
                }
                return null;
            }
            case 6: {
                return this.readMessage(in, (PMessageDescriptor)descriptor);
            }
            case 7: {
                if (descriptor == null) {
                    int len = in.readIntVarint();
                    int tag = in.readIntVarint();
                    int vtype = tag & 7;
                    int ktype = tag > 7 ? tag >>> 3 : vtype;
                    for (int i = 0; i < len; ++i) {
                        if (i % 2 == 0) {
                            this.readFieldValue(in, ktype, null);
                            continue;
                        }
                        this.readFieldValue(in, vtype, null);
                    }
                    return null;
                }
                if (descriptor.getType() == PType.MAP) {
                    PMap ct = (PMap)descriptor;
                    PDescriptor kt = ct.keyDescriptor();
                    PDescriptor vt = ct.itemDescriptor();
                    PBuilder out = ct.builder();
                    int len = in.readIntVarint();
                    int tag = in.readIntVarint();
                    int vtype = tag & 7;
                    int ktype = tag > 7 ? tag >>> 3 : vtype;
                    for (int i = 0; i < len; ++i) {
                        Object key = this.readFieldValue(in, ktype, kt);
                        Object value = this.readFieldValue(in, vtype, vt);
                        if (key != null && value != null) {
                            out.put(key, value);
                        } else if (this.readStrict) {
                            if (key == null) {
                                throw new SerializerException("Unknown enum key in map", new Object[0]);
                            }
                            throw new SerializerException("Null value in map", new Object[0]);
                        }
                        ++i;
                    }
                    return out.build();
                }
                if (descriptor.getType() == PType.LIST) {
                    PList ct = (PList)descriptor;
                    PDescriptor it = ct.itemDescriptor();
                    PBuilder out = ct.builder();
                    int len = in.readIntVarint();
                    int vtype = in.readIntVarint() & 7;
                    for (int i = 0; i < len; ++i) {
                        Object item = this.readFieldValue(in, vtype, it);
                        if (item != null) {
                            out.add(item);
                            continue;
                        }
                        if (!this.readStrict) continue;
                        throw new SerializerException("Null value in list", new Object[0]);
                    }
                    return out.build();
                }
                if (descriptor.getType() == PType.SET) {
                    PSet ct = (PSet)descriptor;
                    PDescriptor it = ct.itemDescriptor();
                    PBuilder out = ct.builder();
                    int len = in.readIntVarint();
                    int vtype = in.readIntVarint() & 7;
                    for (int i = 0; i < len; ++i) {
                        Object item = this.readFieldValue(in, vtype, it);
                        if (item != null) {
                            out.add(item);
                            continue;
                        }
                        if (!this.readStrict) continue;
                        throw new SerializerException("Null value in set", new Object[0]);
                    }
                    return out.build();
                }
                throw new SerializerException("Type " + (Object)((Object)descriptor.getType()) + " not compatible with collection data", new Object[0]);
            }
        }
        throw new Error("Unreachable code reached");
    }

    private static int itemType(PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BOOL: 
            case BYTE: 
            case I16: 
            case I32: 
            case I64: 
            case ENUM: {
                return 3;
            }
            case DOUBLE: {
                return 4;
            }
            case STRING: 
            case BINARY: {
                return 5;
            }
            case MESSAGE: {
                return 6;
            }
            case MAP: 
            case SET: 
            case LIST: {
                return 7;
            }
        }
        throw new Error("Unreachable code reached");
    }
}

