/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PField;

public abstract class PMessageDescriptor<T extends PMessage<T, F>, F extends PField>
extends PDeclaredDescriptor<T> {
    private final PMessageBuilderFactory<T, F> factory;
    private final boolean simple;

    public PMessageDescriptor(String programName, String name, PMessageBuilderFactory<T, F> factory, boolean simple) {
        super(programName, name);
        this.factory = factory;
        this.simple = simple;
    }

    @Nonnull
    public abstract F[] getFields();

    public abstract F getField(String var1);

    public abstract F getField(int var1);

    public abstract PMessageVariant getVariant();

    public boolean isSimple() {
        return this.simple;
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.MESSAGE;
    }

    public PMessageBuilder<T, F> builder() {
        return this.factory.builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        PMessageDescriptor other = (PMessageDescriptor)o;
        if (!this.getQualifiedName().equals(other.getQualifiedName()) || !this.getVariant().equals((Object)other.getVariant()) || this.getFields().length != other.getFields().length) {
            return false;
        }
        for (PField field : this.getFields()) {
            if (field.equals(other.getField(field.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.getClass(), this.getQualifiedName(), this.getVariant()});
        for (PField field : this.getFields()) {
            hash += Objects.hash(hash *= 28547, field.hashCode());
        }
        return hash;
    }

    protected PMessageBuilderFactory<T, F> getFactoryInternal() {
        return this.factory;
    }
}

