/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;

public abstract class PEnumDescriptor<T extends PEnumValue<T>>
extends PDeclaredDescriptor<T> {
    public static final int DEFAULT_FIRST_VALUE = 0;
    private final PEnumBuilderFactory<T> factory;

    public PEnumDescriptor(String packageName, String name, PEnumBuilderFactory<T> provider) {
        super(packageName, name);
        this.factory = provider;
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.ENUM;
    }

    @Nonnull
    public abstract T[] getValues();

    @Nullable
    public abstract T getValueById(int var1);

    public abstract T getValueByName(String var1);

    @Override
    public PEnumBuilder<T> builder() {
        return this.factory.builder();
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        PEnumDescriptor other = (PEnumDescriptor)o;
        if (!this.getQualifiedName().equals(other.getQualifiedName()) || this.getValues().length != other.getValues().length) {
            return false;
        }
        for (PEnumValue value : this.getValues()) {
            T ovI = other.getValueById(value.getValue());
            if (ovI == null || value.getName().equals(ovI.getName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(PEnumDescriptor.class, this.getQualifiedName());
    }

    protected PEnumBuilderFactory<T> getFactoryInternal() {
        return this.factory;
    }
}

