/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util.pretty;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import net.morimekta.providence.util.pretty.Token;
import net.morimekta.providence.util.pretty.TokenizerException;
import net.morimekta.util.Slice;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;

public class Tokenizer
extends InputStream {
    private final byte[] buffer;
    private int readOffset;
    private int lineNo;
    private int linePos;
    private Token nextToken;

    public Tokenizer(InputStream in, boolean enclosedContent) throws IOException {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        if (enclosedContent) {
            int r;
            int stack = 0;
            int literal = 0;
            boolean escaped = false;
            boolean comment = false;
            while ((r = in.read()) >= 0) {
                if (comment) {
                    if (r == 10 || r == 13) {
                        comment = false;
                    }
                    tmp.write(r);
                    continue;
                }
                if (literal != 0) {
                    if (escaped) {
                        escaped = false;
                    } else if (r == literal) {
                        literal = 0;
                        escaped = false;
                    } else if (r == 92) {
                        escaped = true;
                    }
                } else if (r != 32 && r != 9 && r != 13 && r != 10) {
                    if (r == 34 || r == 39) {
                        literal = (char)r;
                    } else {
                        if (r == 35) {
                            comment = true;
                            continue;
                        }
                        if (r == 125) {
                            if (--stack <= 0) {
                                tmp.write(r);
                                break;
                            }
                        } else if (r == 123) {
                            ++stack;
                        }
                    }
                }
                tmp.write(r);
            }
        } else {
            IOUtils.copy((InputStream)in, (OutputStream)tmp);
        }
        this.buffer = tmp.toByteArray();
        this.readOffset = -1;
        this.lineNo = 1;
        this.linePos = -1;
    }

    @Override
    public int read() {
        if (++this.readOffset >= this.buffer.length) {
            this.readOffset = this.buffer.length;
            return -1;
        }
        int ret = this.buffer[this.readOffset];
        if (ret == 10) {
            ++this.lineNo;
            this.linePos = -1;
        } else {
            ++this.linePos;
        }
        return ret > 0 ? ret : 256 + ret;
    }

    private void unread() {
        if (this.readOffset == this.buffer.length) {
            --this.readOffset;
            return;
        }
        if (this.buffer[this.readOffset--] == 10) {
            --this.lineNo;
        } else {
            --this.linePos;
        }
    }

    public Token expect(String message) throws IOException {
        if (!this.hasNext()) {
            throw new TokenizerException("Expected %s, got end of file", message);
        }
        Token next = this.nextToken;
        this.nextToken = null;
        return next;
    }

    public Token peek(String message) throws IOException {
        if (!this.hasNext()) {
            throw new TokenizerException("Expected %s, got end of file", message);
        }
        return this.nextToken;
    }

    public Token peek() throws IOException {
        this.hasNext();
        return this.nextToken;
    }

    public char expectSymbol(String message, char ... symbols) throws IOException {
        if (!this.hasNext()) {
            throw new TokenizerException("Expected %s, got end of file", message);
        }
        for (char symbol : symbols) {
            if (!this.nextToken.isSymbol(symbol)) continue;
            this.nextToken = null;
            return symbol;
        }
        throw new TokenizerException(this.nextToken, "Expected %s, but found '%s'", message, Strings.escape((CharSequence)this.nextToken.asString())).setLine(this.getLine(this.nextToken.getLineNo()));
    }

    public Token expectIdentifier(String message) throws IOException {
        if (!this.hasNext()) {
            throw new TokenizerException("Expected %s, got end of file", message);
        }
        if (this.nextToken.isIdentifier()) {
            Token next = this.nextToken;
            this.nextToken = null;
            return next;
        }
        throw new TokenizerException(this.nextToken, "Expected %s, but got '%s'", message, Strings.escape((CharSequence)this.nextToken.asString())).setLine(this.getLine(this.nextToken.getLineNo()));
    }

    public Token expectStringLiteral(String message) throws IOException {
        if (!this.hasNext()) {
            throw new TokenizerException("Expected %s, got end of file", message);
        }
        if (this.nextToken.isStringLiteral()) {
            Token next = this.nextToken;
            this.nextToken = null;
            return next;
        }
        throw new TokenizerException(this.nextToken, "Expected %s, but got '%s'", message, Strings.escape((CharSequence)this.nextToken.asString())).setLine(this.getLine(this.nextToken.getLineNo()));
    }

    public boolean hasNext() throws IOException {
        if (this.nextToken == null) {
            this.nextToken = this.nextInternal();
        }
        return this.nextToken != null;
    }

    public Token next() throws IOException {
        if (this.nextToken != null) {
            Token tmp = this.nextToken;
            this.nextToken = null;
            return tmp;
        }
        return this.nextInternal();
    }

    private Token nextStringLiteral(int startQuote) throws TokenizerException {
        int startOffset = this.readOffset;
        int startLineNo = this.lineNo;
        int startLinePos = this.linePos;
        boolean escaped = false;
        while (true) {
            int r;
            if ((r = this.read()) < 32 || r == 127) {
                int pos = startOffset - this.readOffset + 2;
                if (r == -1) {
                    throw new TokenizerException("Unexpected end of stream in literal", new Object[0]).setLineNo(startLineNo).setLinePos(startLinePos + pos + 1).setLine(this.getLine(startLineNo));
                }
                if (r == 10) {
                    throw new TokenizerException("Unexpected line break in literal", new Object[0]).setLineNo(startLineNo).setLinePos(startLinePos + pos).setLine(this.getLine(startLineNo));
                }
                throw new TokenizerException("Unescaped non-printable char in literal: '%s'", Strings.escape((CharSequence)String.valueOf((char)r))).setLineNo(startLineNo).setLinePos(startLinePos + pos).setLine(this.getLine(startLineNo));
            }
            if (escaped) {
                escaped = false;
                continue;
            }
            if (r == 92) {
                escaped = true;
                continue;
            }
            if (startQuote == r) break;
        }
        return new Token(this.buffer, startOffset, this.readOffset - startOffset + 1, this.lineNo, startLinePos);
    }

    private Token nextInternal() throws IOException {
        int r;
        int startOffset = this.readOffset;
        while ((r = this.read()) != -1) {
            if (r == 32 || r == 9 || r == 13 || r == 10) continue;
            if (r == 35) {
                while ((r = this.read()) != -1 && r != 10 && r != 13) {
                }
                continue;
            }
            startOffset = this.readOffset;
            break;
        }
        if (r < 0) {
            return null;
        }
        if ("{}:=()<>,;#[]&/%$@^".indexOf(r) >= 0) {
            return new Token(this.buffer, startOffset, 1, this.lineNo, this.linePos);
        }
        if (r == 39 || r == 34) {
            return this.nextStringLiteral(r);
        }
        if (r == 46 || r == 45 || r >= 48 && r <= 57) {
            return this.nextNumber(r);
        }
        if (r == 95 || r >= 97 && r <= 122 || r >= 65 && r <= 90) {
            return this.nextIdentifier();
        }
        throw new TokenizerException("Unknown token initiator '%c'", r).setLineNo(this.lineNo).setLinePos(this.linePos).setLine(this.getLine(this.lineNo));
    }

    private Token nextNumber(int lastByte) throws TokenizerException {
        int startLinePos = this.linePos;
        int startOffset = this.readOffset;
        int len = 0;
        if (lastByte == 45) {
            lastByte = this.read();
            if (lastByte < 0) {
                throw new TokenizerException("Unexpected end of stream after negative indicator", new Object[0]).setLineNo(this.lineNo).setLinePos(startLinePos + len).setLine(this.getLine(this.lineNo));
            }
            ++len;
            if (lastByte != 46 && (lastByte < 48 || lastByte > 57)) {
                throw new TokenizerException("No decimal after negative indicator", new Object[0]).setLineNo(this.lineNo).setLinePos(startLinePos + len).setLine(this.getLine(this.lineNo));
            }
        } else if (lastByte == 48) {
            lastByte = this.read();
            ++len;
            if (lastByte == 120) {
                while ((lastByte = this.read()) != -1) {
                    if (lastByte >= 48 && lastByte <= 57 || lastByte >= 97 && lastByte <= 102 || lastByte >= 65 && lastByte <= 70) {
                        ++len;
                        continue;
                    }
                    this.unread();
                    break;
                }
                return new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
            }
            if (49 <= lastByte && lastByte <= 55) {
                while ((lastByte = this.read()) != -1) {
                    if (lastByte >= 48 && lastByte <= 55) {
                        ++len;
                        continue;
                    }
                    this.unread();
                    break;
                }
                return new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
            }
        }
        while (lastByte >= 48 && lastByte <= 57) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) continue;
        }
        if (lastByte == 46) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) {
                while (lastByte >= 48 && lastByte <= 57) {
                    ++len;
                    lastByte = this.read();
                    if (lastByte >= 0) continue;
                }
            }
        }
        if (lastByte == 101 || lastByte == 69) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) {
                if (lastByte == 45 || lastByte == 43) {
                    ++len;
                    lastByte = this.read();
                }
                while (lastByte >= 48 && lastByte <= 57) {
                    ++len;
                    lastByte = this.read();
                    if (lastByte >= 0) continue;
                }
            }
        }
        Token token = new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
        if (lastByte < 0 || lastByte == 32 || lastByte == 9 || lastByte == 10 || lastByte == 13 || lastByte == 58 || lastByte == 125 || lastByte == 93 || lastByte == 44 || lastByte == 59 || lastByte == 35) {
            if ("{}:=()<>,;#[]&/%$@^".indexOf(lastByte) >= 0) {
                this.unread();
            }
            return token;
        }
        throw new TokenizerException(token, "Invalid termination of number: '%s%s'", Strings.escape((CharSequence)token.asString()), Tokenizer.escapeChar(lastByte)).setLinePos(startLinePos + len).setLine(this.getLine(this.lineNo));
    }

    private Token nextIdentifier() throws TokenizerException {
        int r;
        int startOffset = this.readOffset;
        int startLinePos = this.linePos;
        int len = 1;
        boolean dot = false;
        while ((r = this.read()) != -1) {
            if (r == 46) {
                if (dot) {
                    throw new TokenizerException("Identifier with double '.'", new Object[0]).setLineNo(this.lineNo).setLinePos(startLinePos + len).setLine(this.getLine(this.lineNo));
                }
                dot = true;
                ++len;
                continue;
            }
            dot = false;
            if (r == 95 || r >= 48 && r <= 57 || r >= 97 && r <= 122 || r >= 65 && r <= 90) {
                ++len;
                continue;
            }
            this.unread();
            break;
        }
        Token token = new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
        if (dot) {
            throw new TokenizerException("Identifier trailing with '.'", new Object[0]).setLineNo(this.lineNo).setLinePos(this.linePos).setLine(this.getLine(this.lineNo));
        }
        if (r == -1 || r == 32 || r == 9 || r == 10 || r == 13 || "{}:=()<>,;#[]&/%$@^".indexOf(r) >= 0) {
            return token;
        }
        throw new TokenizerException("Wrongly terminated identifier: %s", Tokenizer.escapeChar(r)).setLineNo(this.lineNo).setLinePos(this.linePos).setLine(this.getLine(this.lineNo));
    }

    public String getLine(int theLine) {
        if (theLine < 1) {
            throw new IllegalStateException(theLine + " is not a valid line number. Must be 1 .. N");
        }
        int originalReadOffset = this.readOffset;
        int originalLineNo = this.lineNo;
        int originalLinePos = this.linePos;
        this.readOffset = -1;
        this.lineNo = 1;
        this.linePos = -1;
        try {
            int line = theLine;
            while (--line > 0) {
                if (IOUtils.skipUntil((InputStream)this, (byte)10)) continue;
                throw new IOException("No such line " + theLine);
            }
            String string = IOUtils.readString((InputStream)this, (String)"\n");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.readOffset = originalReadOffset;
            this.lineNo = originalLineNo;
            this.linePos = originalLinePos;
        }
    }

    public String readBinary(char end) throws TokenizerException {
        int r;
        int startOffset = this.readOffset + 1;
        int startLinePos = this.linePos;
        int startLineNo = this.lineNo;
        while ((r = this.read()) != -1) {
            if (r == end) {
                return new Slice(this.buffer, startOffset, this.readOffset - startOffset).asString();
            }
            if (r != 32 && r != 9 && r != 10 && r != 13) continue;
            throw new TokenizerException("Illegal char '%s' in binary", Tokenizer.escapeChar(r)).setLineNo(this.lineNo).setLinePos(this.linePos).setLine(this.getLine(this.lineNo));
        }
        throw new TokenizerException("unexpected end of stream in binary", new Object[0]).setLineNo(startLineNo).setLinePos(startLinePos);
    }

    private static String escapeChar(int c) {
        return Strings.escape((CharSequence)new String(new char[]{(char)c}));
    }
}

