/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.streams;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collector;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.streams.MessageStreams;

public class MessageCollectors {
    public static <Message extends PMessage<Message, Field>, Field extends PField> Collector<Message, OutputStream, Integer> toPath(Path file, Serializer serializer) {
        return MessageCollectors.toFile(file.toFile(), serializer);
    }

    public static <Message extends PMessage<Message, Field>, Field extends PField> Collector<Message, OutputStream, Integer> toFile(File file, Serializer serializer) {
        AtomicInteger result = new AtomicInteger(0);
        return Collector.of(() -> {
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to open " + file.getName(), e);
            }
        }, (outputStream, t) -> {
            try {
                result.addAndGet(serializer.serialize((OutputStream)outputStream, t));
                if (!serializer.binaryProtocol()) {
                    result.addAndGet(MessageCollectors.maybeWriteBytes(outputStream, MessageStreams.READABLE_ENTRY_SEP));
                }
            }
            catch (SerializerException e) {
                throw new UncheckedIOException("Bad data", new IOException(e));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to write to " + file.getName(), e);
            }
        }, (a, b) -> null, outputStream -> {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to close " + file.getName(), e);
            }
            return result.get();
        }, new Collector.Characteristics[0]);
    }

    public static <Message extends PMessage<Message, Field>, Field extends PField> Collector<Message, OutputStream, Integer> toStream(OutputStream out, Serializer serializer) {
        AtomicInteger result = new AtomicInteger(0);
        return Collector.of(() -> new BufferedOutputStream(out), (outputStream, t) -> {
            try {
                OutputStream outputStream2 = outputStream;
                synchronized (outputStream2) {
                    result.addAndGet(serializer.serialize((OutputStream)outputStream, t));
                    if (!serializer.binaryProtocol()) {
                        result.addAndGet(MessageCollectors.maybeWriteBytes(outputStream, MessageStreams.READABLE_ENTRY_SEP));
                    }
                }
            }
            catch (SerializerException e) {
                throw new UncheckedIOException("Bad data", new IOException(e));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Broken pipe", e);
            }
        }, (a, b) -> null, outputStream -> {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Broken pipe", e);
            }
            return result.get();
        }, new Collector.Characteristics[0]);
    }

    private static int maybeWriteBytes(OutputStream out, byte[] bytes) {
        if (bytes.length > 0) {
            try {
                out.write(bytes);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return bytes.length;
    }
}

