/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.util.pretty.Token;
import net.morimekta.providence.util.pretty.Tokenizer;
import net.morimekta.providence.util.pretty.TokenizerException;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.CountingOutputStream;
import net.morimekta.util.io.IndentedPrintWriter;

public class PrettySerializer
extends Serializer {
    public static final String MIME_TYPE = "text/plain";
    private static final String INDENT = "  ";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String LIST_SEP = ",";
    private final String indent;
    private final String space;
    private final String newline;
    private final String entrySep;
    private final boolean encloseOuter;
    private final boolean strict;
    private final boolean prefixWithQualifiedName;

    public PrettySerializer() {
        this(false);
    }

    public PrettySerializer(boolean strict) {
        this(INDENT, SPACE, NEWLINE, "", true, strict, false);
    }

    public PrettySerializer compact() {
        return new PrettySerializer("", "", "", LIST_SEP, true, this.strict, false);
    }

    public PrettySerializer string() {
        return new PrettySerializer("", "", "", LIST_SEP, true, this.strict, true);
    }

    public PrettySerializer config() {
        return new PrettySerializer(this.indent, this.space, this.newline, this.entrySep, true, this.strict, true);
    }

    public PrettySerializer debug() {
        return new PrettySerializer(this.indent, this.space, this.newline, this.entrySep, false, this.strict, this.prefixWithQualifiedName);
    }

    private PrettySerializer(String indent, String space, String newline, String entrySep, boolean encloseOuter, boolean strict, boolean prefixWithQualifiedName) {
        this.indent = indent;
        this.space = space;
        this.newline = newline;
        this.entrySep = entrySep;
        this.encloseOuter = encloseOuter;
        this.strict = strict;
        this.prefixWithQualifiedName = prefixWithQualifiedName;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream out, Message message) {
        CountingOutputStream cout = new CountingOutputStream(out);
        IndentedPrintWriter builder = new IndentedPrintWriter((OutputStream)cout, this.indent, this.newline);
        if (this.prefixWithQualifiedName) {
            builder.append((CharSequence)message.descriptor().getQualifiedName()).append((CharSequence)this.space);
        }
        this.appendMessage(builder, message, this.encloseOuter || this.prefixWithQualifiedName);
        builder.flush();
        return cout.getByteCount();
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream out, PServiceCall<Message, Field> call) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(out);
        IndentedPrintWriter builder = new IndentedPrintWriter((OutputStream)cout, this.indent, this.newline);
        builder.format("%d: %s %s(", new Object[]{call.getSequence(), call.getType().getName(), call.getMethod()}).begin(this.indent + this.indent);
        this.appendMessage(builder, (PMessage<?, ?>)call.getMessage(), true);
        builder.end().append(')').newline().flush();
        return cout.getByteCount();
    }

    @Override
    @Nonnull
    public <Message extends PMessage<Message, Field>, Field extends PField> PServiceCall<Message, Field> deserialize(InputStream input, PService service) throws IOException {
        String methodName = null;
        int sequence = 0;
        PServiceCallType callType = null;
        try {
            PApplicationException message;
            Tokenizer tokenizer = new Tokenizer(input, false);
            Token token = tokenizer.expect("Sequence or type");
            if (token.isInteger()) {
                sequence = (int)token.parseInteger();
                tokenizer.expectSymbol("Sequence type sep", ':');
                token = tokenizer.expectIdentifier("Call Type");
            }
            if ((callType = PServiceCallType.forName(token.asString())) == null) {
                throw new TokenizerException(token, "No such call type " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo())).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            token = tokenizer.expectIdentifier("method name");
            methodName = token.asString();
            PServiceMethod method = service.getMethod(methodName);
            if (method == null) {
                throw new TokenizerException(token, "no such method " + methodName + " on service " + service.getQualifiedName(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo())).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            tokenizer.expectSymbol("call params start", '(');
            tokenizer.expectSymbol("message encloser", '{');
            switch (callType) {
                case CALL: 
                case ONEWAY: {
                    message = this.readMessage(tokenizer, method.getRequestType(), true);
                    break;
                }
                case REPLY: {
                    message = this.readMessage(tokenizer, method.getResponseType(), true);
                    break;
                }
                case EXCEPTION: {
                    message = this.readMessage(tokenizer, PApplicationException.kDescriptor, true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unreachable code reached");
                }
            }
            tokenizer.expectSymbol("Call params closing", ')');
            return new PServiceCall(methodName, callType, sequence, message);
        }
        catch (TokenizerException e) {
            throw new TokenizerException(e, null).setCallType(callType).setSequenceNo(sequence).setMethodName(methodName);
        }
        catch (IOException e) {
            throw new SerializerException(e, e.getMessage(), new Object[0]).setCallType(callType).setSequenceNo(sequence).setMethodName(methodName);
        }
    }

    @Override
    @Nonnull
    public <Message extends PMessage<Message, Field>, Field extends PField> Message deserialize(InputStream input, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        Tokenizer tokenizer = new Tokenizer(input, this.encloseOuter);
        Token first = tokenizer.peek();
        if (first == null) {
            return (Message)((PMessage)descriptor.builder().build());
        }
        boolean requireEnd = false;
        if (first.asString().equals(descriptor.getQualifiedName())) {
            tokenizer.next();
            tokenizer.expectSymbol("message start", '{');
            requireEnd = true;
        } else if (first.isSymbol('{')) {
            tokenizer.next();
            requireEnd = true;
        }
        return this.readMessage(tokenizer, descriptor, requireEnd);
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message readMessage(Tokenizer tokenizer, PMessageDescriptor<Message, Field> descriptor, boolean requireEnd) throws IOException {
        PBuilder builder = descriptor.builder();
        Token token = tokenizer.next();
        while (true) {
            if (token == null) {
                if (!requireEnd) break;
                throw new TokenizerException("Unexpected end of stream", new Object[0]);
            }
            if (token.isSymbol('}')) break;
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Expected field name, got '%s'", Strings.escape((CharSequence)token.asString())).setLine(tokenizer.getLine(token.getLineNo()));
            }
            tokenizer.expectSymbol("field value separator", '=');
            Field field = descriptor.getField(token.asString());
            if (field == null) {
                if (this.strict) {
                    throw new TokenizerException(token, "No such field %s on %s", token.asString(), descriptor.getQualifiedName()).setLine(tokenizer.getLine(token.getLineNo()));
                }
                this.consumeValue(tokenizer, tokenizer.expect("field value"));
            } else {
                ((PMessageBuilder)builder).set(field.getKey(), this.readFieldValue(tokenizer, tokenizer.expect("field value"), field.getDescriptor()));
            }
            token = tokenizer.peek();
            if (token != null && (token.isSymbol(',') || token.isSymbol(';'))) {
                tokenizer.next();
            }
            token = tokenizer.next();
        }
        return (Message)((PMessage)builder.build());
    }

    private Object readFieldValue(Tokenizer tokenizer, Token token, PDescriptor descriptor) throws IOException {
        switch (descriptor.getType()) {
            case VOID: {
                switch (token.asString().toLowerCase()) {
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                }
                throw new TokenizerException(token, "Invalid void value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case BOOL: {
                switch (token.asString().toLowerCase()) {
                    case "1": 
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                    case "0": 
                    case "f": 
                    case "false": 
                    case "n": 
                    case "no": {
                        return Boolean.FALSE;
                    }
                }
                throw new TokenizerException(token, "Invalid boolean value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case BYTE: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > 127L || val < -128L) {
                        throw new TokenizerException(token, "Byte value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (byte)val;
                }
                throw new TokenizerException(token, "Invalid byte value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I16: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > 32767L || val < -32768L) {
                        throw new TokenizerException(token, "Short value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (short)val;
                }
                throw new TokenizerException(token, "Invalid byte value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I32: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                        throw new TokenizerException(token, "Integer value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (int)val;
                }
                throw new TokenizerException(token, "Invalid byte value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I64: {
                if (token.isInteger()) {
                    return token.parseInteger();
                }
                throw new TokenizerException(token, "Invalid byte value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case DOUBLE: {
                try {
                    return token.parseDouble();
                }
                catch (NumberFormatException nfe) {
                    throw new TokenizerException(token, "Number format error: " + nfe.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
            }
            case STRING: {
                if (!token.isStringLiteral()) {
                    throw new TokenizerException(token, "Expected string literal, got '%s'", token.asString()).setLine(tokenizer.getLine(token.getLineNo()));
                }
                return token.decodeLiteral();
            }
            case BINARY: {
                tokenizer.expectSymbol("binary content start", '(');
                String content = tokenizer.readBinary(')');
                switch (token.asString()) {
                    case "b64": {
                        return Binary.fromBase64((String)content);
                    }
                    case "hex": {
                        return Binary.fromHexString((String)content);
                    }
                }
                throw new TokenizerException(token, "Unrecognized binary format " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case ENUM: {
                PBuilder b = ((PEnumDescriptor)descriptor).builder();
                ((PEnumBuilder)b).setByName(token.asString());
                if (this.strict && !((PEnumBuilder)b).valid()) {
                    throw new TokenizerException(token, "No such " + descriptor.getQualifiedName() + " value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                return b.build();
            }
            case MESSAGE: {
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected message start, got '%s'", token.asString()).setLine(tokenizer.getLine(token.getLineNo()));
                }
                return this.readMessage(tokenizer, (PMessageDescriptor)descriptor, true);
            }
            case MAP: {
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected map start, got '%s'", token.asString()).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PMap pMap = (PMap)descriptor;
                PDescriptor kDesc = pMap.keyDescriptor();
                PDescriptor iDesc = pMap.itemDescriptor();
                PBuilder builder = pMap.builder();
                token = tokenizer.expect("list end or value");
                while (!token.isSymbol('}')) {
                    Object key = this.readFieldValue(tokenizer, token, kDesc);
                    tokenizer.expectSymbol("map kv sep", ':');
                    Object value = this.readFieldValue(tokenizer, tokenizer.expect("map value"), iDesc);
                    builder.put(key, value);
                    token = tokenizer.expect("map sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("map end or value");
                }
                return builder.build();
            }
            case LIST: {
                if (!token.isSymbol('[')) {
                    throw new TokenizerException(token, "Expected list start, got '%s'", token.asString()).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PList pList = (PList)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PBuilder builder = pList.builder();
                token = tokenizer.expect("list end or value");
                while (!token.isSymbol(']')) {
                    builder.add(this.readFieldValue(tokenizer, token, iDesc));
                    token = tokenizer.expect("list sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("list end or value");
                }
                return builder.build();
            }
            case SET: {
                if (!token.isSymbol('[')) {
                    throw new TokenizerException(token, "Expected set start, got '%s'", token.asString()).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PSet pList = (PSet)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PBuilder builder = pList.builder();
                token = tokenizer.expect("set end or value");
                while (!token.isSymbol(']')) {
                    builder.add(this.readFieldValue(tokenizer, token, iDesc));
                    token = tokenizer.expect("set sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("set end or value");
                }
                return builder.build();
            }
        }
        throw new IllegalStateException("Unhandled field type: " + (Object)((Object)descriptor.getType()));
    }

    @Override
    public boolean binaryProtocol() {
        return false;
    }

    @Override
    public String mimeType() {
        return MIME_TYPE;
    }

    private void appendMessage(IndentedPrintWriter builder, PMessage<?, ?> message, boolean enclose) {
        PDescriptor type = message.descriptor();
        if (enclose) {
            builder.append('{').begin();
        }
        if (message instanceof PUnion) {
            Object field = ((PUnion)message).unionField();
            if (field != null) {
                Object o = message.get(field.getKey());
                if (enclose) {
                    builder.appendln();
                }
                builder.append((CharSequence)field.getName()).append((CharSequence)this.space).append('=').append((CharSequence)this.space);
                this.appendTypedValue(builder, field.getDescriptor(), o);
            }
        } else {
            boolean first = true;
            for (PField field : type.getFields()) {
                if (!message.has(field.getKey())) continue;
                if (first) {
                    first = false;
                    if (enclose) {
                        builder.appendln();
                    }
                } else {
                    builder.append((CharSequence)this.entrySep);
                    builder.appendln();
                }
                Object o = message.get(field.getKey());
                builder.append((CharSequence)field.getName()).append((CharSequence)this.space).append('=').append((CharSequence)this.space);
                this.appendTypedValue(builder, field.getDescriptor(), o);
            }
        }
        if (enclose) {
            builder.end().appendln('}');
        }
    }

    private void appendTypedValue(IndentedPrintWriter writer, PDescriptor descriptor, Object o) {
        switch (descriptor.getType()) {
            case LIST: 
            case SET: {
                PContainer containerType = (PContainer)descriptor;
                PDescriptor itemType = containerType.itemDescriptor();
                Collection collection = (Collection)o;
                PPrimitive primitive = PPrimitive.findByName(itemType.getName());
                if (primitive != null && primitive != PPrimitive.STRING && primitive != PPrimitive.BINARY && collection.size() <= 10) {
                    writer.append('[');
                    boolean first = true;
                    for (Object i : collection) {
                        if (first) {
                            first = false;
                        } else {
                            writer.append(',').append((CharSequence)this.space);
                        }
                        this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                    }
                    writer.append(']');
                    break;
                }
                writer.append('[').begin();
                boolean first = true;
                for (Object i : collection) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',');
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.end().appendln(']');
                break;
            }
            case MAP: {
                PMap mapType = (PMap)descriptor;
                Map map = (Map)o;
                writer.append('{').begin();
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append((CharSequence)this.entrySep);
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, mapType.keyDescriptor(), entry.getKey());
                    writer.append(':').append((CharSequence)this.space);
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.end().appendln('}');
                break;
            }
            case VOID: {
                writer.print(true);
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)o;
                this.appendMessage(writer, message, true);
                break;
            }
            default: {
                this.appendPrimitive(writer, o);
            }
        }
    }

    private void appendPrimitive(IndentedPrintWriter writer, Object o) {
        if (o instanceof PEnumValue) {
            writer.print(((PEnumValue)o).asString());
        } else if (o instanceof CharSequence) {
            writer.print('\"');
            writer.print(Strings.escape((CharSequence)((CharSequence)o)));
            writer.print('\"');
        } else if (o instanceof Binary) {
            Binary b = (Binary)o;
            writer.append((CharSequence)"b64").append('(').append((CharSequence)b.toBase64()).append(')');
        } else if (o instanceof Boolean) {
            writer.print(((Boolean)o).booleanValue());
        } else if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
            writer.print(Strings.escape((CharSequence)o.toString()));
        } else if (o instanceof Double) {
            Double d = (Double)o;
            if (d == (double)d.longValue()) {
                writer.print(d.longValue());
            } else {
                writer.print(d.doubleValue());
            }
        } else {
            throw new IllegalArgumentException("Unknown primitive type class " + o.getClass().getSimpleName());
        }
    }

    private void consumeValue(Tokenizer tokenizer, Token token) throws IOException {
        if (token.isSymbol('{')) {
            token = tokenizer.expect("map or message first entry");
            if (!token.isSymbol('}') && !token.isIdentifier()) {
                while (!token.isSymbol('}')) {
                    if (token.isIdentifier() || token.isReferenceIdentifier()) {
                        throw new TokenizerException(token, "Invalid map key: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    this.consumeValue(tokenizer, token);
                    tokenizer.expectSymbol("key value sep.", ':');
                    this.consumeValue(tokenizer, tokenizer.expect("map value"));
                    token = tokenizer.expect("map key, end or sep");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("map key or end");
                }
            } else {
                while (!token.isSymbol('}')) {
                    if (!token.isIdentifier()) {
                        throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    tokenizer.expectSymbol("field value sep.", '=');
                    this.consumeValue(tokenizer, tokenizer.next());
                    token = this.nextNotLineSep(tokenizer);
                }
            }
        } else if (token.isSymbol('[')) {
            token = tokenizer.next();
            while (!token.isSymbol(']')) {
                this.consumeValue(tokenizer, token);
                if (tokenizer.expectSymbol("list separator or end", ',', ']') != ']') {
                    token = tokenizer.expect("list value or end");
                    continue;
                }
                break;
            }
        } else if (token.asString().equals("hex")) {
            tokenizer.expectSymbol("hex body start", '(');
            tokenizer.readBinary(')');
        } else if (!(token.isReal() || token.isInteger() || token.isStringLiteral() || token.isIdentifier())) {
            throw new TokenizerException(token, "Unknown value token '%s'", token.asString()).setLine(tokenizer.getLine(token.getLineNo()));
        }
    }

    private Token nextNotLineSep(Tokenizer tokenizer) throws IOException {
        if (tokenizer.peek().isSymbol(',') || tokenizer.peek().isSymbol(';')) {
            tokenizer.expect("message field or end");
        }
        return tokenizer.expect("message field or end");
    }
}

