/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import javax.annotation.Nonnull;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PRequirement;

public interface PField {
    public int getKey();

    @Nonnull
    public PRequirement getRequirement();

    @Nonnull
    default public PType getType() {
        return this.getDescriptor().getType();
    }

    @Nonnull
    public PDescriptor getDescriptor();

    @Nonnull
    public String getName();

    public boolean hasDefaultValue();

    public Object getDefaultValue();

    public static String asString(PField field) {
        StringBuilder builder = new StringBuilder();
        builder.append("field(").append(field.getKey()).append(": ");
        if (field.getRequirement() != PRequirement.DEFAULT) {
            builder.append(field.getRequirement().label).append(" ");
        }
        builder.append(field.getDescriptor().getQualifiedName()).append(' ').append(field.getName()).append(')');
        return builder.toString();
    }
}

