/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;

public abstract class PMessageBuilder<T extends PMessage<T, F>, F extends PField>
implements PBuilder<T> {
    public abstract boolean valid();

    public abstract void validate() throws IllegalStateException;

    @Nonnull
    public abstract PMessageBuilder<T, F> set(int var1, Object var2);

    @Nonnull
    public PMessageBuilder<T, F> set(@Nonnull F field, Object value) {
        return this.set((F)field.getKey(), value);
    }

    public abstract boolean isSet(int var1);

    public boolean isSet(@Nonnull F field) {
        return this.isSet(field.getKey());
    }

    @Nonnull
    public Collection<F> collectSetFields() {
        return Arrays.stream(this.descriptor().getFields()).filter(this::isSet).collect(Collectors.toList());
    }

    public abstract boolean isModified(int var1);

    public boolean isModified(@Nonnull F field) {
        return this.isModified(field.getKey());
    }

    @Nonnull
    public Collection<F> modifiedFields() {
        return Arrays.stream(this.descriptor().getFields()).filter(this::isModified).collect(Collectors.toList());
    }

    @Nonnull
    public abstract PMessageBuilder<T, F> addTo(int var1, Object var2);

    @Nonnull
    public PMessageBuilder<T, F> addTo(@Nonnull F field, Object value) {
        return this.addTo((F)field.getKey(), value);
    }

    @Nonnull
    public abstract PMessageBuilder<T, F> clear(int var1);

    @Nonnull
    public PMessageBuilder<T, F> clear(@Nonnull F field) {
        return this.clear((F)field.getKey());
    }

    @Nonnull
    public abstract PMessageBuilder<T, F> merge(T var1);

    @Nonnull
    public abstract PMessageBuilder mutator(int var1);

    @Nonnull
    public PMessageBuilder mutator(@Nonnull F field) {
        return this.mutator(field.getKey());
    }

    @Nonnull
    public abstract PMessageDescriptor<T, F> descriptor();
}

