/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util.pretty;

import com.google.common.base.MoreObjects;
import java.io.File;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.util.pretty.Token;
import net.morimekta.util.Strings;

public class TokenizerException
extends SerializerException {
    private int lineNo;
    private int linePos;
    private String line;
    private String file;

    public TokenizerException(TokenizerException e, File file) {
        super(e);
        this.setLine(e.getLine());
        this.setLineNo(e.getLineNo());
        this.setLinePos(e.getLinePos());
        if (e.getFile() == null && file != null) {
            this.setFile(file.getName());
        } else {
            this.setFile(e.getFile());
        }
    }

    public TokenizerException(String format, Object ... args) {
        super(format, args);
    }

    public TokenizerException(Throwable cause, String format, Object ... args) {
        super(cause, format, args);
    }

    public TokenizerException(Token token, String format, Object ... args) {
        super(format, args);
        this.setLinePos(token.getLinePos());
        this.setLineNo(token.getLineNo());
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public TokenizerException setLineNo(int lineNo) {
        this.lineNo = lineNo;
        return this;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public TokenizerException setLinePos(int linePos) {
        this.linePos = linePos;
        return this;
    }

    public String getLine() {
        return this.line;
    }

    public TokenizerException setLine(String line) {
        this.line = line;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public TokenizerException setFile(String file) {
        this.file = file;
        return this;
    }

    @Override
    public String asString() {
        if (this.lineNo > 0) {
            String fileSpec = "";
            if (this.file != null) {
                fileSpec = " in " + this.file;
            }
            if (this.line != null) {
                return String.format("Error%s on line %d, pos %d:%n    %s%n%s%n%s^", fileSpec, this.getLineNo(), this.getLinePos(), this.getMessage(), this.getLine(), Strings.times((String)"-", (int)this.getLinePos()));
            }
            return String.format("Error%s on line %d, pos %d: %s", fileSpec, this.getLineNo(), this.getLinePos(), this.getMessage());
        }
        return this.getMessage();
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this.getClass()).omitNullValues().addValue((Object)this.getMessage()).add("file", (Object)this.file);
        if (this.lineNo > 0) {
            helper.add("lineNo", this.lineNo);
            helper.add("linePos", this.linePos);
        }
        return helper.toString();
    }
}

