/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.util.pretty.Token;
import net.morimekta.providence.util.pretty.Tokenizer;
import net.morimekta.providence.util.pretty.TokenizerException;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.CountingOutputStream;
import net.morimekta.util.io.IndentedPrintWriter;

public class PrettySerializer
extends Serializer {
    public static final String MIME_TYPE = "text/plain";
    private static final String INDENT = "  ";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String LIST_SEP = ",";
    private final String indent;
    private final String space;
    private final String newline;
    private final String entrySep;
    private final boolean encloseOuter;

    public PrettySerializer() {
        this(INDENT, SPACE, NEWLINE, LIST_SEP, true);
    }

    public PrettySerializer(String indent, String space, String newline, String entrySep, boolean encloseOuter) {
        this.indent = indent;
        this.space = space;
        this.newline = newline;
        this.entrySep = entrySep;
        this.encloseOuter = encloseOuter;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream out, Message message) {
        CountingOutputStream cout = new CountingOutputStream(out);
        IndentedPrintWriter builder = new IndentedPrintWriter((OutputStream)cout, this.indent, this.newline);
        this.appendMessage(builder, message, this.encloseOuter);
        builder.flush();
        return cout.getByteCount();
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream out, PServiceCall<Message, Field> call) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(out);
        IndentedPrintWriter builder = new IndentedPrintWriter((OutputStream)cout, this.indent, this.newline);
        builder.format("%d: %s %s(", new Object[]{call.getSequence(), call.getType().getName(), call.getMethod()}).begin(this.indent + this.indent);
        this.appendMessage(builder, (PMessage<?, ?>)call.getMessage(), true);
        builder.end().append(')').newline().flush();
        return cout.getByteCount();
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> PServiceCall<Message, Field> deserialize(InputStream input, PService service) throws IOException {
        String methodName = null;
        int sequence = 0;
        PServiceCallType callType = null;
        try {
            PApplicationException message;
            Tokenizer tokenizer = new Tokenizer(input, false);
            Token token = tokenizer.expect("Sequence or type");
            if (token.isInteger()) {
                sequence = (int)token.parseInteger();
                tokenizer.expectSymbol("Sequence type sep", ':');
                token = tokenizer.expectIdentifier("Call Type");
            }
            if ((callType = PServiceCallType.forName(token.asString())) == null) {
                throw new TokenizerException(token, "No such call type " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo())).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            token = tokenizer.expectIdentifier("method name");
            methodName = token.asString();
            PServiceMethod method = service.getMethod(methodName);
            if (method == null) {
                throw new TokenizerException(token, "no such method " + methodName + " on service " + service.getQualifiedName(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo())).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            tokenizer.expectSymbol("call params start", '(');
            tokenizer.expectSymbol("message encloser", '{');
            switch (callType) {
                case CALL: 
                case ONEWAY: {
                    message = this.readMessage(tokenizer, method.getRequestType(), true);
                    break;
                }
                case REPLY: {
                    message = this.readMessage(tokenizer, method.getResponseType(), true);
                    break;
                }
                case EXCEPTION: {
                    message = this.readMessage(tokenizer, PApplicationException.kDescriptor, true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unreachable code reached");
                }
            }
            tokenizer.expectSymbol("Call params closing", ')');
            return new PServiceCall(methodName, callType, sequence, message);
        }
        catch (TokenizerException e) {
            throw new TokenizerException(e, null).setCallType(callType).setSequenceNo(sequence).setMethodName(methodName);
        }
        catch (IOException e) {
            throw new SerializerException(e, e.getMessage(), new Object[0]).setCallType(callType).setSequenceNo(sequence).setMethodName(methodName);
        }
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> Message deserialize(InputStream input, PMessageDescriptor<Message, Field> descriptor) throws IOException {
        Tokenizer tokenizer = new Tokenizer(input, this.encloseOuter);
        Token first = tokenizer.peek();
        if (first != null && first.isSymbol('{')) {
            tokenizer.next();
            return this.readMessage(tokenizer, descriptor, true);
        }
        return this.readMessage(tokenizer, descriptor, false);
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message readMessage(Tokenizer tokenizer, PMessageDescriptor<Message, Field> descriptor, boolean requireEnd) throws IOException {
        PBuilder builder = descriptor.builder();
        while (true) {
            Token t = tokenizer.next();
            if (!requireEnd ? t == null : t != null && t.isSymbol('}')) break;
            if (t == null) {
                throw new TokenizerException("Unexpected end of stream", new Object[0]);
            }
            if (!t.isIdentifier()) {
                throw new TokenizerException(t, "Expected field name, got '%s'", Strings.escape((CharSequence)t.asString())).setLine(tokenizer.getLine(t.getLineNo()));
            }
            Field field = descriptor.getField(t.asString());
            if (field == null) {
                throw new TokenizerException(t, "No such field %s on %s", t.asString(), descriptor.getQualifiedName()).setLine(tokenizer.getLine(t.getLineNo()));
            }
            tokenizer.expectSymbol("field value separator", ':', '=');
            if (field.getType() == PType.LIST) {
                t = tokenizer.peek("list field value");
                if (t.isSymbol('[')) {
                    ((PMessageBuilder)builder).set(field.getKey(), this.readFieldValue(tokenizer, field.getDescriptor()));
                } else {
                    ((PMessageBuilder)builder).addTo(field.getKey(), this.readFieldValue(tokenizer, ((PList)field.getDescriptor()).itemDescriptor()));
                }
            } else {
                ((PMessageBuilder)builder).set(field.getKey(), this.readFieldValue(tokenizer, field.getDescriptor()));
            }
            if ((t = tokenizer.peek()) == null || !t.isSymbol(',') && !t.isSymbol(';')) continue;
            tokenizer.next();
        }
        return (Message)((PMessage)builder.build());
    }

    private Object readFieldValue(Tokenizer tokenizer, PDescriptor descriptor) throws IOException {
        switch (descriptor.getType()) {
            case VOID: {
                Token t = tokenizer.expect("void value");
                switch (t.asString().toLowerCase()) {
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                }
                throw new TokenizerException(t, "Invalid void value " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
            }
            case BOOL: {
                Token t = tokenizer.expect("boolean value");
                switch (t.asString().toLowerCase()) {
                    case "1": 
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                    case "0": 
                    case "f": 
                    case "false": 
                    case "n": 
                    case "no": {
                        return Boolean.FALSE;
                    }
                }
                throw new TokenizerException(t, "Invalid boolean value " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
            }
            case BYTE: {
                Token t = tokenizer.expect("byte value");
                if (t.isInteger()) {
                    long val = t.parseInteger();
                    if (val > 127L || val < -128L) {
                        throw new TokenizerException(t, "Byte value out of bounds: " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
                    }
                    return (byte)val;
                }
                throw new TokenizerException(t, "Invalid byte value: " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
            }
            case I16: {
                Token t = tokenizer.expect("byte value");
                if (t.isInteger()) {
                    long val = t.parseInteger();
                    if (val > 32767L || val < -32768L) {
                        throw new TokenizerException(t, "Short value out of bounds: " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
                    }
                    return (short)val;
                }
                throw new TokenizerException(t, "Invalid byte value: " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
            }
            case I32: {
                Token t = tokenizer.expect("byte value");
                if (t.isInteger()) {
                    long val = t.parseInteger();
                    if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                        throw new TokenizerException(t, "Integer value out of bounds: " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
                    }
                    return (int)val;
                }
                throw new TokenizerException(t, "Invalid byte value: " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
            }
            case I64: {
                Token t = tokenizer.expect("byte value");
                if (t.isInteger()) {
                    return t.parseInteger();
                }
                throw new TokenizerException(t, "Invalid byte value: " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
            }
            case DOUBLE: {
                Token t = tokenizer.expect("byte value");
                try {
                    return t.parseDouble();
                }
                catch (NumberFormatException nfe) {
                    throw new TokenizerException(t, "Number format error: " + nfe.getMessage(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
                }
            }
            case STRING: {
                Token t = tokenizer.expectStringLiteral("string value");
                return t.decodeLiteral();
            }
            case BINARY: {
                Token t = tokenizer.expectIdentifier("binary format");
                tokenizer.expectSymbol("binary content start", '(');
                String content = tokenizer.readUntil(')', false, false);
                switch (t.asString()) {
                    case "b64": {
                        return Binary.fromBase64((String)content);
                    }
                    case "hex": {
                        return Binary.fromHexString((String)content);
                    }
                }
                throw new TokenizerException(t, "Unrecognized binary format " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
            }
            case ENUM: {
                Token t = tokenizer.expectIdentifier("enum value");
                PBuilder b = ((PEnumDescriptor)descriptor).builder();
                ((PEnumBuilder)b).setByName(t.asString());
                if (!((PEnumBuilder)b).valid()) {
                    throw new TokenizerException(t, "No such " + descriptor.getQualifiedName() + " value " + t.asString(), new Object[0]).setLine(tokenizer.getLine(t.getLineNo()));
                }
                return b.build();
            }
            case MESSAGE: {
                tokenizer.expectSymbol("message start", '{');
                return this.readMessage(tokenizer, (PMessageDescriptor)descriptor, true);
            }
            case MAP: {
                PMap pMap = (PMap)descriptor;
                PDescriptor kDesc = pMap.keyDescriptor();
                PDescriptor iDesc = pMap.itemDescriptor();
                PBuilder builder = pMap.builder();
                tokenizer.expectSymbol("map start", '{');
                if (tokenizer.peek("map end or value").isSymbol('}')) {
                    tokenizer.next();
                } else {
                    while (true) {
                        Object key = this.readFieldValue(tokenizer, kDesc);
                        tokenizer.expectSymbol("mep kv sep", ':');
                        Object value = this.readFieldValue(tokenizer, iDesc);
                        builder.put(key, value);
                        Token t = tokenizer.peek("map sep, end or value");
                        if (t.isSymbol(',') || t.isSymbol(';')) {
                            tokenizer.next();
                            continue;
                        }
                        if (t.isSymbol('}')) break;
                    }
                    tokenizer.next();
                }
                return builder.build();
            }
            case LIST: {
                PList pList = (PList)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PBuilder builder = pList.builder();
                tokenizer.expectSymbol("list start", '[');
                if (tokenizer.peek("empty list").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    while (true) {
                        Object value = this.readFieldValue(tokenizer, iDesc);
                        builder.add(value);
                        Token t = tokenizer.peek("list sep, end or value");
                        if (t.isSymbol(',') || t.isSymbol(';')) {
                            tokenizer.next();
                            continue;
                        }
                        if (t.isSymbol(']')) break;
                    }
                    tokenizer.next();
                }
                return builder.build();
            }
            case SET: {
                PSet pList = (PSet)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PBuilder builder = pList.builder();
                tokenizer.expectSymbol("set start", '[');
                if (tokenizer.peek("empty set").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    while (true) {
                        Object value = this.readFieldValue(tokenizer, iDesc);
                        builder.add(value);
                        Token t = tokenizer.peek("set sep, end or value");
                        if (t.isSymbol(',') || t.isSymbol(';')) {
                            tokenizer.next();
                            continue;
                        }
                        if (t.isSymbol(']')) break;
                    }
                    tokenizer.next();
                }
                return builder.build();
            }
        }
        return null;
    }

    @Override
    public boolean binaryProtocol() {
        return false;
    }

    @Override
    public String mimeType() {
        return MIME_TYPE;
    }

    private void appendMessage(IndentedPrintWriter builder, PMessage<?, ?> message, boolean enclose) {
        PDescriptor type = message.descriptor();
        if (enclose) {
            builder.append('{').begin();
        }
        if (message instanceof PUnion) {
            Object field = ((PUnion)message).unionField();
            if (field != null) {
                Object o = message.get(field.getKey());
                if (enclose) {
                    builder.appendln();
                }
                builder.append((CharSequence)field.getName()).append((CharSequence)this.space).append('=').append((CharSequence)this.space);
                this.appendTypedValue(builder, field.getDescriptor(), o);
            }
        } else {
            boolean first = true;
            for (PField field : type.getFields()) {
                if (!message.has(field.getKey())) continue;
                if (first) {
                    first = false;
                    if (enclose) {
                        builder.appendln();
                    }
                } else {
                    builder.append((CharSequence)this.entrySep).appendln();
                }
                Object o = message.get(field.getKey());
                builder.append((CharSequence)field.getName()).append((CharSequence)this.space).append('=').append((CharSequence)this.space);
                this.appendTypedValue(builder, field.getDescriptor(), o);
            }
        }
        if (enclose) {
            builder.end().appendln('}');
        }
    }

    private void appendTypedValue(IndentedPrintWriter writer, PDescriptor descriptor, Object o) {
        switch (descriptor.getType()) {
            case LIST: 
            case SET: {
                PContainer containerType = (PContainer)descriptor;
                PDescriptor itemType = containerType.itemDescriptor();
                Collection collection = (Collection)o;
                PPrimitive primitive = PPrimitive.findByName(itemType.getName());
                if (primitive != null && primitive != PPrimitive.STRING && primitive != PPrimitive.BINARY && collection.size() <= 10) {
                    writer.append('[');
                    boolean first = true;
                    for (Object i : collection) {
                        if (first) {
                            first = false;
                        } else {
                            writer.append(',').append((CharSequence)this.space);
                        }
                        this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                    }
                    writer.append(']');
                    break;
                }
                writer.append('[').begin();
                boolean first = true;
                for (Object i : collection) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',');
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.end().appendln(']');
                break;
            }
            case MAP: {
                PMap mapType = (PMap)descriptor;
                Map map = (Map)o;
                writer.append('{').begin();
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append((CharSequence)this.entrySep);
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, mapType.keyDescriptor(), entry.getKey());
                    writer.append(':').append((CharSequence)this.space);
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.end().appendln('}');
                break;
            }
            case VOID: {
                writer.print(true);
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)o;
                this.appendMessage(writer, message, true);
                break;
            }
            default: {
                this.appendPrimitive(writer, o);
            }
        }
    }

    private void appendPrimitive(IndentedPrintWriter writer, Object o) {
        if (o instanceof PEnumValue) {
            writer.print(((PEnumValue)o).asString());
        } else if (o instanceof CharSequence) {
            writer.print('\"');
            writer.print(Strings.escape((CharSequence)((CharSequence)o)));
            writer.print('\"');
        } else if (o instanceof Binary) {
            Binary b = (Binary)o;
            writer.append((CharSequence)"b64").append('(').append((CharSequence)b.toBase64()).append(')');
        } else if (o instanceof Boolean) {
            writer.print(((Boolean)o).booleanValue());
        } else if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
            writer.print(Strings.escape((CharSequence)o.toString()));
        } else if (o instanceof Double) {
            Double d = (Double)o;
            if (d == (double)d.longValue()) {
                writer.print(d.longValue());
            } else if (d > 5119.0 || 1.0 / d > 640.0) {
                writer.print(new DecimalFormat("0.#########E0").format(d));
            } else {
                writer.print(d.doubleValue());
            }
        } else {
            throw new IllegalArgumentException("Unknown primitive type class " + o.getClass().getSimpleName());
        }
    }
}

