/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.CountingOutputStream;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;
import net.morimekta.util.json.JsonWriter;
import net.morimekta.util.json.PrettyJsonWriter;

public class JsonSerializer
extends Serializer {
    public static final String MIME_TYPE = "application/vnd.morimekta.providence.json";
    public static final String JSON_MIME_TYPE = "application/json";
    private final boolean readStrict;
    private final IdType idType;
    private final IdType enumType;
    private final boolean pretty;

    public JsonSerializer() {
        this(true, IdType.ID, IdType.ID, false);
    }

    public JsonSerializer(boolean strict) {
        this(strict, IdType.ID, IdType.ID, false);
    }

    public JsonSerializer(IdType idType) {
        this(true, idType, idType, false);
    }

    public JsonSerializer(boolean readStrict, IdType idType) {
        this(readStrict, idType, idType, false);
    }

    public JsonSerializer(IdType idType, IdType enumType) {
        this(true, idType, enumType, false);
    }

    public JsonSerializer(boolean readStrict, IdType idType, IdType enumType, boolean pretty) {
        this.readStrict = readStrict;
        this.idType = idType;
        this.enumType = enumType;
        this.pretty = pretty;
    }

    public <T extends PMessage<T, F>, F extends PField> int serialize(OutputStream output, T message) throws SerializerException {
        CountingOutputStream counter = new CountingOutputStream(output);
        PrettyJsonWriter jsonWriter = this.pretty ? new PrettyJsonWriter((OutputStream)counter) : new JsonWriter((OutputStream)counter);
        try {
            this.appendMessage((JsonWriter)jsonWriter, message);
            jsonWriter.flush();
            counter.flush();
            return counter.getByteCount();
        }
        catch (JsonException e) {
            throw new SerializerException(e, "Unable to serialize JSON", new Object[0]);
        }
        catch (IOException e) {
            throw new SerializerException(e, "Unable to write to stream", new Object[0]);
        }
    }

    public <T extends PMessage<T, F>, F extends PField> int serialize(OutputStream output, PServiceCall<T, F> call) throws IOException {
        CountingOutputStream counter = new CountingOutputStream(output);
        PrettyJsonWriter jsonWriter = this.pretty ? new PrettyJsonWriter((OutputStream)counter) : new JsonWriter((OutputStream)counter);
        try {
            jsonWriter.array().value((CharSequence)call.getMethod());
            if (this.enumType == IdType.ID) {
                jsonWriter.value(call.getType().getValue());
            } else {
                jsonWriter.value((CharSequence)call.getType().getName());
            }
            jsonWriter.value(call.getSequence());
            this.appendMessage((JsonWriter)jsonWriter, (PMessage<?, ?>)call.getMessage());
            jsonWriter.endArray().flush();
            counter.flush();
            return counter.getByteCount();
        }
        catch (JsonException e) {
            throw new SerializerException(e, "Unable to serialize JSON", new Object[0]);
        }
        catch (IOException e) {
            throw new SerializerException(e, "Unable to write to stream", new Object[0]);
        }
    }

    public <T extends PMessage<T, TF>, TF extends PField> T deserialize(InputStream input, PMessageDescriptor<T, TF> type) throws SerializerException {
        try {
            JsonTokenizer tokenizer = new JsonTokenizer(input);
            if (!tokenizer.hasNext()) {
                return null;
            }
            return (T)((PMessage)this.parseTypedValue(tokenizer.next(), tokenizer, type));
        }
        catch (JsonException e) {
            throw new SerializerException(e, "Unable to parse JSON", new Object[0]);
        }
        catch (IOException e) {
            throw new SerializerException(e, "Unable to read stream", new Object[0]);
        }
    }

    public <T extends PMessage<T, F>, F extends PField> PServiceCall<T, F> deserialize(InputStream input, PService service) throws IOException {
        JsonTokenizer tokenizer = new JsonTokenizer(input);
        return this.parseServiceCall(tokenizer, service);
    }

    @Override
    public boolean binaryProtocol() {
        return false;
    }

    @Override
    public String mimeType() {
        return MIME_TYPE;
    }

    private <T extends PMessage<T, F>, F extends PField> PServiceCall<T, F> parseServiceCall(JsonTokenizer tokenizer, PService service) throws IOException {
        PServiceCallType type = null;
        String methodName = null;
        int sequence = 0;
        try {
            tokenizer.expectSymbol("Service call start", new char[]{'['});
            methodName = tokenizer.expectString("Service call method").decodeJsonLiteral();
            tokenizer.expectSymbol("Service call sep", new char[]{','});
            JsonToken callTypeToken = tokenizer.expect("Service call type");
            if (callTypeToken.isInteger()) {
                byte typeKey = callTypeToken.byteValue();
                type = PServiceCallType.forValue(typeKey);
                if (type == null) {
                    throw new SerializerException("Service call type " + typeKey + " is not valid.", new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
            } else if (callTypeToken.isLiteral()) {
                String typeName = callTypeToken.decodeJsonLiteral();
                type = PServiceCallType.forName(typeName);
                if (type == null) {
                    throw new SerializerException("Service call type " + typeName + " is not valid.", new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
            } else {
                throw new SerializerException("Invalid service call type token " + callTypeToken.asString(), new Object[0]).setExceptionType(PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            tokenizer.expectSymbol("Service call sep", new char[]{','});
            sequence = tokenizer.expectNumber("Service call sequence").intValue();
            tokenizer.expectSymbol("Service call sep", new char[]{','});
            if (type == PServiceCallType.EXCEPTION) {
                PApplicationException ex = (PApplicationException)this.parseTypedValue(tokenizer.expect("Message start"), tokenizer, PApplicationException.kDescriptor);
                tokenizer.expectSymbol("Service call end", new char[]{']'});
                return new PServiceCall(methodName, type, sequence, ex);
            }
            PServiceMethod method = service.getMethod(methodName);
            if (method == null) {
                throw new SerializerException("No such method " + methodName + " on " + service.getQualifiedName(), new Object[0]).setExceptionType(PApplicationExceptionType.UNKNOWN_METHOD);
            }
            PMessageDescriptor descriptor = this.isRequestCallType(type) ? method.getRequestType() : method.getResponseType();
            PMessage message = (PMessage)this.parseTypedValue(tokenizer.expect("Message start"), tokenizer, descriptor);
            tokenizer.expectSymbol("Service call end", new char[]{']'});
            return new PServiceCall(methodName, type, sequence, message);
        }
        catch (SerializerException se) {
            throw new SerializerException(se).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
        catch (IOException | JsonException ie) {
            throw new SerializerException(ie, ie.getMessage(), new Object[0]).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
    }

    private <T extends PMessage<T, F>, F extends PField> T parseMessage(JsonTokenizer tokenizer, PMessageDescriptor<T, F> type) throws JsonException, IOException {
        PBuilder builder = type.builder();
        if (tokenizer.peek("checking for empty message").isSymbol('}')) {
            tokenizer.next();
        } else {
            int sep = 123;
            while (sep != 125) {
                JsonToken token = tokenizer.expect("parsing message key");
                String key = token.substring(1, -1).asString();
                F field = Strings.isInteger((String)key) ? type.getField(Integer.parseInt(key)) : type.getField(key);
                tokenizer.expectSymbol("parsing message field key sep", new char[]{':'});
                if (field != null) {
                    Object value = this.parseTypedValue(tokenizer.expect("parsing message field value"), tokenizer, field.getDescriptor());
                    ((PMessageBuilder)builder).set(field.getKey(), value);
                } else {
                    if (this.readStrict) {
                        throw new SerializerException("Unknown field " + key + " for type " + type.getQualifiedName(), new Object[0]);
                    }
                    this.consume(tokenizer.expect("consuming unknown message value"), tokenizer);
                }
                sep = tokenizer.expectSymbol("parsing message entry sep", new char[]{'}', ','});
            }
        }
        if (this.readStrict) {
            try {
                ((PMessageBuilder)builder).validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException(e, e.getMessage(), new Object[0]);
            }
        }
        return (T)((PMessage)builder.build());
    }

    private <T extends PMessage<T, F>, F extends PField> T parseCompactMessage(JsonTokenizer tokenizer, PMessageDescriptor<T, F> type) throws SerializerException, IOException, JsonException {
        PBuilder builder = type.builder();
        int i = 0;
        int sep = 91;
        while (sep != 93) {
            F field;
            if ((field = type.getField(++i)) != null) {
                Object value = this.parseTypedValue(tokenizer.expect("parsing compact message field value"), tokenizer, field.getDescriptor());
                ((PMessageBuilder)builder).set(i, value);
            } else {
                if (this.readStrict) {
                    throw new SerializerException("Compact Field ID " + i + " outside field spectrum for type " + type.getQualifiedName(), new Object[0]);
                }
                this.consume(tokenizer.expect("consuming compact message field value"), tokenizer);
            }
            sep = tokenizer.expectSymbol("parsing compact message entry sep", new char[]{']', ','});
        }
        if (this.readStrict) {
            try {
                ((PMessageBuilder)builder).validate();
            }
            catch (IllegalStateException e) {
                throw new SerializerException(e, e.getMessage(), new Object[0]);
            }
        }
        return (T)((PMessage)builder.build());
    }

    private void consume(JsonToken token, JsonTokenizer tokenizer) throws IOException, JsonException {
        block6: {
            block7: {
                if (!token.isSymbol()) break block6;
                if (!token.isSymbol('[')) break block7;
                if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    int sep = 91;
                    while (sep != 93) {
                        this.consume(tokenizer.expect("consuming list item"), tokenizer);
                        sep = tokenizer.expectSymbol("consuming list sep", new char[]{']', ','});
                    }
                }
                break block6;
            }
            if (!token.isSymbol('{')) break block6;
            if (tokenizer.peek("checking for empty map").isSymbol('}')) {
                tokenizer.next();
            } else {
                int sep = 123;
                while (sep != 125) {
                    tokenizer.expectString("consuming map key");
                    tokenizer.expectSymbol("consuming map kv sep", new char[]{':'});
                    this.consume(tokenizer.expect("consuming map value"), tokenizer);
                    sep = tokenizer.expectSymbol("consuming map entry sep", new char[]{'}', ','});
                }
            }
        }
    }

    private Object parseTypedValue(JsonToken token, JsonTokenizer tokenizer, PDescriptor t) throws IOException {
        if (token.isNull()) {
            return null;
        }
        try {
            switch (t.getType()) {
                case VOID: {
                    return token.booleanValue() ? Boolean.TRUE : null;
                }
                case BOOL: {
                    if (token.isBoolean()) {
                        return token.booleanValue();
                    }
                    if (token.isInteger()) {
                        return token.intValue() != 0;
                    }
                    throw new SerializerException("Not boolean value for token: " + token.asString(), new Object[0]);
                }
                case BYTE: {
                    if (token.isInteger()) {
                        return token.byteValue();
                    }
                    throw new SerializerException("Not a valid byte value: " + token.asString(), new Object[0]);
                }
                case I16: {
                    if (token.isInteger()) {
                        return token.shortValue();
                    }
                    throw new SerializerException("Not a valid short value: " + token.asString(), new Object[0]);
                }
                case I32: {
                    if (token.isInteger()) {
                        return token.intValue();
                    }
                    throw new SerializerException("Not a valid int value: " + token.asString(), new Object[0]);
                }
                case I64: {
                    if (token.isInteger()) {
                        return token.longValue();
                    }
                    throw new SerializerException("Not a valid long value: " + token.asString(), new Object[0]);
                }
                case DOUBLE: {
                    if (token.isNumber()) {
                        return token.doubleValue();
                    }
                    throw new SerializerException("Not a valid double value: " + token.asString(), new Object[0]);
                }
                case STRING: {
                    if (token.isLiteral()) {
                        return token.decodeJsonLiteral();
                    }
                    throw new SerializerException("Not a valid string value: " + token.asString(), new Object[0]);
                }
                case BINARY: {
                    if (token.isLiteral()) {
                        try {
                            return Binary.fromBase64((String)token.substring(1, -1).asString());
                        }
                        catch (IllegalArgumentException e) {
                            throw new SerializerException(e, "Unable to parse Base64 data.", new Object[0]);
                        }
                    }
                    throw new SerializerException("Not a valid binary value: " + token.asString(), new Object[0]);
                }
                case ENUM: {
                    PBuilder eb = ((PEnumDescriptor)t).builder();
                    if (token.isInteger()) {
                        ((PEnumBuilder)eb).setByValue(token.intValue());
                    } else if (token.isLiteral()) {
                        ((PEnumBuilder)eb).setByName(token.substring(1, -1).asString());
                    } else {
                        throw new SerializerException(token.toString() + " is not a enum value type", new Object[0]);
                    }
                    if (this.readStrict && !((PEnumBuilder)eb).valid()) {
                        throw new SerializerException(token.toString() + " is not a enum value", new Object[0]);
                    }
                    return eb.build();
                }
                case MESSAGE: {
                    PMessageDescriptor st = (PMessageDescriptor)t;
                    if (token.isSymbol('{')) {
                        return this.parseMessage(tokenizer, st);
                    }
                    if (token.isSymbol('[')) {
                        if (st.isCompactible()) {
                            return this.parseCompactMessage(tokenizer, st);
                        }
                        throw new SerializerException(st.getName() + " is not compatible for compact struct notation.", new Object[0]);
                    }
                    throw new SerializerException(token + " not parsable message start.", new Object[0]);
                }
                case MAP: {
                    PMap mapType = (PMap)t;
                    PDescriptor itemType = mapType.itemDescriptor();
                    PDescriptor keyType = mapType.keyDescriptor();
                    if (!token.isSymbol('{')) {
                        throw new SerializerException("Incompatible start of map " + token, new Object[0]);
                    }
                    PBuilder map = mapType.builder();
                    if (tokenizer.peek("checking for empty map").isSymbol('}')) {
                        tokenizer.next();
                    } else {
                        int sep = 123;
                        while (sep != 125) {
                            Object key = this.parseMapKey(tokenizer.expectString("parsing map key").decodeJsonLiteral(), keyType);
                            tokenizer.expectSymbol("parsing map K/V sep", new char[]{':'});
                            Object value = this.parseTypedValue(tokenizer.expect("parsing map value"), tokenizer, itemType);
                            map.put(key, value);
                            sep = tokenizer.expectSymbol("parsing map entry sep", new char[]{'}', ','});
                        }
                    }
                    return map.build();
                }
                case SET: {
                    PDescriptor itemType = ((PSet)t).itemDescriptor();
                    if (!token.isSymbol('[')) {
                        throw new SerializerException("Incompatible start of list " + token, new Object[0]);
                    }
                    PBuilder set = ((PSet)t).builder();
                    if (tokenizer.peek("checking for empty set").isSymbol(']')) {
                        tokenizer.next();
                    } else {
                        int sep = 91;
                        while (sep != 93) {
                            set.add(this.parseTypedValue(tokenizer.expect("parsing set value"), tokenizer, itemType));
                            sep = tokenizer.expectSymbol("parsing set entry sep", new char[]{',', ']'});
                        }
                    }
                    return set.build();
                }
                case LIST: {
                    PDescriptor itemType = ((PList)t).itemDescriptor();
                    if (!token.isSymbol('[')) {
                        throw new SerializerException("Incompatible start of list " + token, new Object[0]);
                    }
                    PBuilder list = ((PList)t).builder();
                    if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                        tokenizer.next();
                    } else {
                        int sep = 91;
                        while (sep != 93) {
                            list.add(this.parseTypedValue(tokenizer.expect("parsing list value"), tokenizer, itemType));
                            sep = tokenizer.expectSymbol("parsing list entry sep", new char[]{',', ']'});
                        }
                    }
                    return list.build();
                }
            }
        }
        catch (JsonException je) {
            throw new SerializerException(je, "Unable to parse type value.", new Object[0]);
        }
        catch (ClassCastException ce) {
            throw new SerializerException(ce, "Serialized type  not compatible with " + t.getQualifiedName(), new Object[0]);
        }
        throw new SerializerException("Unhandled item type " + t.getQualifiedName(), new Object[0]);
    }

    private Object parseMapKey(String key, PDescriptor keyType) throws SerializerException {
        try {
            switch (keyType.getType()) {
                case BOOL: {
                    return Boolean.parseBoolean(key);
                }
                case BYTE: {
                    return Byte.parseByte(key);
                }
                case I16: {
                    return Short.parseShort(key);
                }
                case I32: {
                    return Integer.parseInt(key);
                }
                case I64: {
                    return Long.parseLong(key);
                }
                case DOUBLE: {
                    try {
                        JsonTokenizer tokenizer = new JsonTokenizer((InputStream)new ByteArrayInputStream(key.getBytes(StandardCharsets.US_ASCII)));
                        JsonToken token = tokenizer.next();
                        if (!token.isNumber()) {
                            throw new SerializerException(key + " is not a number", new Object[0]);
                        }
                        return token.doubleValue();
                    }
                    catch (JsonException e) {
                        throw new SerializerException(e, "Unable to parse double from key \"" + key + "\"", new Object[0]);
                    }
                    catch (IOException e) {
                        throw new SerializerException(e, "Unable to parse double from key \"" + key + "\" (IO)", new Object[0]);
                    }
                }
                case STRING: {
                    return key;
                }
                case BINARY: {
                    try {
                        return Binary.fromBase64((String)key);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SerializerException(e, "Unable to parse Base64 data.", new Object[0]);
                    }
                }
                case ENUM: {
                    PBuilder eb = ((PEnumDescriptor)keyType).builder();
                    if (Strings.isInteger((String)key)) {
                        ((PEnumBuilder)eb).setByValue(Integer.parseInt(key));
                    } else {
                        ((PEnumBuilder)eb).setByName(key);
                    }
                    if (this.readStrict && !((PEnumBuilder)eb).valid()) {
                        throw new SerializerException("%s is not a valid enum value for %s", key, keyType.getQualifiedName());
                    }
                    return eb.build();
                }
                case MESSAGE: {
                    PMessageDescriptor st = (PMessageDescriptor)keyType;
                    if (!st.isSimple()) {
                        throw new SerializerException("Only simple structs can be used as map key. %s is not.", st.getQualifiedName());
                    }
                    ByteArrayInputStream input = new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8));
                    try {
                        JsonTokenizer tokenizer = new JsonTokenizer((InputStream)input);
                        tokenizer.expectSymbol("Message start", new char[]{'{'});
                        return this.parseMessage(tokenizer, st);
                    }
                    catch (IOException e) {
                        throw new SerializerException(e, "Unable to tokenize map key: %s", key);
                    }
                    catch (JsonException e) {
                        throw new SerializerException(e, "Unable to parse map key: %s", key);
                    }
                }
            }
            throw new SerializerException("Illegal key type: %s", new Object[]{keyType.getType()});
        }
        catch (NumberFormatException nfe) {
            throw new SerializerException(nfe, "Unable to parse numeric value %s", key);
        }
    }

    private void appendMessage(JsonWriter writer, PMessage<?, ?> message) throws SerializerException, JsonException {
        PDescriptor type = message.descriptor();
        if (message instanceof PUnion) {
            writer.object();
            Object field = ((PUnion)message).unionField();
            if (field != null) {
                Object value = message.get(field.getKey());
                if (IdType.ID.equals((Object)this.idType)) {
                    writer.key(field.getKey());
                } else {
                    writer.key((CharSequence)field.getName());
                }
                this.appendTypedValue(writer, field.getDescriptor(), value);
            }
            writer.endObject();
        } else if (message.compact()) {
            writer.array();
            for (PField field : type.getFields()) {
                if (!message.has(field.getKey())) break;
                this.appendTypedValue(writer, field.getDescriptor(), message.get(field.getKey()));
            }
            writer.endArray();
        } else {
            writer.object();
            for (PField field : type.getFields()) {
                if (!message.has(field.getKey())) continue;
                Object value = message.get(field.getKey());
                if (IdType.ID.equals((Object)this.idType)) {
                    writer.key(field.getKey());
                } else {
                    writer.key((CharSequence)field.getName());
                }
                this.appendTypedValue(writer, field.getDescriptor(), value);
            }
            writer.endObject();
        }
    }

    private void appendTypedValue(JsonWriter writer, PDescriptor type, Object value) throws SerializerException, JsonException {
        switch (type.getType()) {
            case VOID: {
                writer.value(true);
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)value;
                this.appendMessage(writer, message);
                break;
            }
            case MAP: {
                writer.object();
                PMap mapType = (PMap)type;
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.appendPrimitiveKey(writer, entry.getKey());
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.endObject();
                break;
            }
            case SET: 
            case LIST: {
                writer.array();
                PContainer containerType = (PContainer)type;
                Collection collection = (Collection)value;
                for (Object i : collection) {
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.endArray();
                break;
            }
            default: {
                this.appendPrimitive(writer, value);
            }
        }
    }

    private void appendPrimitiveKey(JsonWriter writer, Object primitive) throws JsonException, SerializerException {
        if (primitive instanceof PEnumValue) {
            if (IdType.ID.equals((Object)this.idType)) {
                writer.key(((PEnumValue)primitive).getValue());
            } else {
                writer.key((CharSequence)primitive.toString());
            }
        } else if (primitive instanceof Boolean) {
            writer.key(((Boolean)primitive).booleanValue());
        } else if (primitive instanceof Byte) {
            writer.key(((Byte)primitive).byteValue());
        } else if (primitive instanceof Short) {
            writer.key(((Short)primitive).shortValue());
        } else if (primitive instanceof Integer) {
            writer.key(((Integer)primitive).intValue());
        } else if (primitive instanceof Long) {
            writer.key(((Long)primitive).longValue());
        } else if (primitive instanceof Double) {
            writer.key(((Double)primitive).doubleValue());
        } else if (primitive instanceof String) {
            writer.key((CharSequence)((String)primitive));
        } else if (primitive instanceof Binary) {
            writer.key((Binary)primitive);
        } else if (primitive instanceof PMessage) {
            PMessage message = (PMessage)primitive;
            if (!((PMessageDescriptor)message.descriptor()).isSimple()) {
                throw new SerializerException("Only simple messages can be used as map keys. " + message.descriptor().getQualifiedName() + " is not.", new Object[0]);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter json = new JsonWriter((OutputStream)baos);
            this.appendMessage(json, message);
            json.flush();
            writer.key((CharSequence)new String(baos.toByteArray(), StandardCharsets.UTF_8));
        } else {
            throw new SerializerException("illegal simple type class " + primitive.getClass().getSimpleName(), new Object[0]);
        }
    }

    private void appendPrimitive(JsonWriter writer, Object primitive) throws JsonException, SerializerException {
        if (primitive instanceof PEnumValue) {
            if (IdType.ID.equals((Object)this.enumType)) {
                writer.value(((PEnumValue)primitive).getValue());
            } else {
                writer.value((CharSequence)primitive.toString());
            }
        } else if (primitive instanceof Boolean) {
            writer.value(((Boolean)primitive).booleanValue());
        } else if (primitive instanceof Byte) {
            writer.value(((Byte)primitive).byteValue());
        } else if (primitive instanceof Short) {
            writer.value(((Short)primitive).shortValue());
        } else if (primitive instanceof Integer) {
            writer.value(((Integer)primitive).intValue());
        } else if (primitive instanceof Long) {
            writer.value(((Long)primitive).longValue());
        } else if (primitive instanceof Double) {
            writer.value(((Double)primitive).doubleValue());
        } else if (primitive instanceof String) {
            writer.value((CharSequence)((String)primitive));
        } else if (primitive instanceof Binary) {
            writer.value((Binary)primitive);
        } else {
            throw new SerializerException("illegal primitive type class " + primitive.getClass().getSimpleName(), new Object[0]);
        }
    }

    public static enum IdType {
        ID,
        NAME;

    }
}

