/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.mio;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.streams.MessageStreams;

public class IOMessageWriter
implements MessageWriter {
    private final OutputStream out;
    private final Serializer serializer;

    public IOMessageWriter(OutputStream out, Serializer serializer) {
        this.out = out;
        this.serializer = serializer;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int write(Message message) throws IOException {
        int ret = this.serializer.serialize(this.out, message);
        if (!this.serializer.binaryProtocol()) {
            this.out.write(MessageStreams.READABLE_ENTRY_SEP);
        }
        return ret;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int write(PServiceCall<Message, Field> call) throws IOException {
        int ret = this.serializer.serialize(this.out, call);
        if (!this.serializer.binaryProtocol()) {
            this.out.write(MessageStreams.READABLE_ENTRY_SEP);
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

