/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.util.LinkedHashMap;
import java.util.Map;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;

public abstract class BaseSerializerProvider
implements SerializerProvider {
    private final Map<String, Serializer> serializerMap;
    private final String defaultContentType;

    public BaseSerializerProvider(String defaultContentType) {
        this.defaultContentType = defaultContentType;
        this.serializerMap = new LinkedHashMap<String, Serializer>();
    }

    @Override
    public Serializer getSerializer(String mediaType) {
        return this.serializerMap.get(mediaType);
    }

    @Override
    public Serializer getDefault() {
        return this.getSerializer(this.defaultContentType);
    }

    protected void register(Serializer serializer, String ... mediaTypes) {
        for (String mimeType : mediaTypes) {
            this.serializerMap.put(mimeType, serializer);
        }
    }
}

