/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.mio;

import java.io.IOException;
import java.io.InputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.serializer.Serializer;

public class IOMessageReader
implements MessageReader {
    private final Serializer serializer;
    private final InputStream in;

    public IOMessageReader(InputStream in, Serializer serializer) {
        this.in = in;
        this.serializer = serializer;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> Message read(PMessageDescriptor<Message, Field> descriptor) throws IOException {
        return this.serializer.deserialize(this.in, descriptor);
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> PServiceCall<Message, Field> read(PService service) throws IOException {
        return this.serializer.deserialize(this.in, service);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

