/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptorProvider;

public class PList<Item>
extends PContainer<List<Item>> {
    private final BuilderFactory<Item> builderFactory;

    public PList(PDescriptorProvider itemType, BuilderFactory<Item> builderFactory) {
        super(itemType);
        this.builderFactory = builderFactory;
    }

    @Override
    @Nonnull
    public String getName() {
        return "list<" + this.itemDescriptor().getName() + ">";
    }

    @Override
    @Nonnull
    public String getQualifiedName(String programContext) {
        return "list<" + this.itemDescriptor().getQualifiedName(programContext) + ">";
    }

    @Override
    @Nonnull
    public PType getType() {
        return PType.LIST;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PList)) {
            return false;
        }
        PList other = (PList)o;
        return other.itemDescriptor().equals(this.itemDescriptor());
    }

    public int hashCode() {
        return PList.class.hashCode() + this.itemDescriptor().hashCode();
    }

    @Override
    public Builder<Item> builder() {
        return this.builderFactory.builder();
    }

    public static <I> PContainerProvider<List<I>, PList<I>> provider(PDescriptorProvider itemDesc) {
        return PList.provider(itemDesc, ImmutableListBuilder::new);
    }

    public static <I> PContainerProvider<List<I>, PList<I>> provider(PDescriptorProvider itemDesc, BuilderFactory<I> builderFactory) {
        return new PContainerProvider<List<I>, PList<I>>(new PList<I>(itemDesc, builderFactory));
    }

    public static class ImmutableListBuilder<I>
    implements Builder<I> {
        private ImmutableList.Builder<I> builder = ImmutableList.builder();

        @Override
        @Nonnull
        public ImmutableListBuilder<I> add(I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public ImmutableListBuilder<I> addAll(Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        @Nonnull
        public ImmutableListBuilder<I> clear() {
            this.builder = ImmutableList.builder();
            return this;
        }

        @Override
        @Nonnull
        public List<I> build() {
            return this.builder.build();
        }
    }

    private static interface BuilderFactory<I>
    extends PBuilderFactory<List<I>> {
        @Override
        @Nonnull
        public Builder<I> builder();
    }

    public static interface Builder<I>
    extends PBuilder<List<I>> {
        @Nonnull
        public Builder<I> add(I var1);

        @Nonnull
        public Builder<I> addAll(Collection<I> var1);

        @Nonnull
        public Builder<I> clear();

        @Override
        @Nonnull
        public List<I> build();
    }
}

