/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence;

import javax.annotation.Nonnull;

public enum PType {
    STOP(0, "stop"),
    VOID(1, "void"),
    BOOL(2, "bool"),
    BYTE(3, "byte"),
    I16(6, "i16"),
    I32(8, "i32"),
    I64(10, "i64"),
    DOUBLE(4, "double"),
    STRING(11, "string"),
    BINARY(11, "binary"),
    ENUM(8, "enum"),
    MESSAGE(12, "message"),
    MAP(13, "map"),
    SET(14, "set"),
    LIST(15, "list");

    public final byte id;
    public final String name;

    private PType(int typeId, String name) {
        this.id = (byte)typeId;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Nonnull
    public static PType findById(byte id) {
        switch (id) {
            case 0: {
                return STOP;
            }
            case 1: {
                return VOID;
            }
            case 2: {
                return BOOL;
            }
            case 3: {
                return BYTE;
            }
            case 4: {
                return DOUBLE;
            }
            case 6: {
                return I16;
            }
            case 8: {
                return I32;
            }
            case 10: {
                return I64;
            }
            case 11: {
                return STRING;
            }
            case 12: {
                return MESSAGE;
            }
            case 13: {
                return MAP;
            }
            case 14: {
                return SET;
            }
            case 15: {
                return LIST;
            }
        }
        return STOP;
    }

    @Nonnull
    public static PType findByName(String name) {
        switch (name) {
            case "stop": {
                return STOP;
            }
            case "void": {
                return VOID;
            }
            case "bool": {
                return BOOL;
            }
            case "byte": {
                return BYTE;
            }
            case "double": {
                return DOUBLE;
            }
            case "i8": {
                return BYTE;
            }
            case "i16": {
                return I16;
            }
            case "i32": {
                return I32;
            }
            case "i64": {
                return I64;
            }
            case "binary": {
                return BINARY;
            }
            case "string": {
                return STRING;
            }
            case "struct": {
                return MESSAGE;
            }
            case "union": {
                return MESSAGE;
            }
            case "exception": {
                return MESSAGE;
            }
            case "map": {
                return MAP;
            }
            case "set": {
                return SET;
            }
            case "list": {
                return LIST;
            }
            case "enum": {
                return ENUM;
            }
        }
        return STOP;
    }

    @Nonnull
    public static String nameForId(byte id) {
        switch (id) {
            case 0: {
                return "stop";
            }
            case 1: {
                return "void";
            }
            case 2: {
                return "bool";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "double";
            }
            case 6: {
                return "i16";
            }
            case 8: {
                return "i32";
            }
            case 10: {
                return "i64";
            }
            case 11: {
                return "string";
            }
            case 12: {
                return "message";
            }
            case 13: {
                return "map";
            }
            case 14: {
                return "set";
            }
            case 15: {
                return "list";
            }
        }
        return String.valueOf(id);
    }
}

