/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer.rw;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.rw.BinaryReader;
import net.morimekta.providence.serializer.rw.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

public class BinaryFormatUtils {
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message readMessage(BigEndianBinaryReader input, PMessageDescriptor<Message, Field> descriptor, boolean readStrict) throws IOException {
        PBuilder builder = descriptor.builder();
        if (builder instanceof BinaryReader) {
            ((BinaryReader)((Object)builder)).readBinary(input, readStrict);
        } else {
            FieldInfo fieldInfo = BinaryFormatUtils.readFieldInfo(input);
            while (fieldInfo != null) {
                Field field = descriptor.getField(fieldInfo.getId());
                if (field != null) {
                    Object value = BinaryFormatUtils.readFieldValue(input, fieldInfo, field.getDescriptor(), readStrict);
                    ((PMessageBuilder)builder).set(field.getKey(), value);
                } else {
                    if (readStrict) {
                        throw new SerializerException("Unknown field " + fieldInfo.getId() + " for type " + descriptor.getQualifiedName(), new Object[0]);
                    }
                    BinaryFormatUtils.readFieldValue(input, fieldInfo, null, false);
                }
                fieldInfo = BinaryFormatUtils.readFieldInfo(input);
            }
            if (readStrict) {
                try {
                    ((PMessageBuilder)builder).validate();
                }
                catch (IllegalStateException e) {
                    throw new SerializerException(e, e.getMessage(), new Object[0]);
                }
            }
        }
        return (Message)((PMessage)builder.build());
    }

    public static void consumeMessage(BigEndianBinaryReader in, boolean readStrict) throws IOException {
        FieldInfo fieldInfo;
        while ((fieldInfo = BinaryFormatUtils.readFieldInfo(in)) != null) {
            BinaryFormatUtils.readFieldValue(in, fieldInfo, null, readStrict);
        }
    }

    private static FieldInfo readFieldInfo(BigEndianBinaryReader in) throws IOException {
        byte type = in.expectByte();
        if (type == PType.STOP.id) {
            return null;
        }
        return new FieldInfo(in.expectShort(), type);
    }

    public static Object readFieldValue(BigEndianBinaryReader in, FieldInfo fieldInfo, PDescriptor type, boolean readStrict) throws IOException {
        if (type == null) {
            if (readStrict) {
                throw new SerializerException("Reading unknown field in strict mode.", new Object[0]);
            }
        } else if (type.getType().id != fieldInfo.getType()) {
            if (readStrict) {
                throw new SerializerException("Mismatching field type in strict mode.", new Object[0]);
            }
            BinaryFormatUtils.readFieldValue(in, fieldInfo, null, readStrict);
            return null;
        }
        switch (PType.findById(fieldInfo.getType())) {
            case VOID: {
                return Boolean.TRUE;
            }
            case BOOL: {
                return in.expectByte() != 0;
            }
            case BYTE: {
                return in.expectByte();
            }
            case I16: {
                return in.expectShort();
            }
            case ENUM: 
            case I32: {
                int val = in.expectInt();
                if (type != null && type instanceof PEnumDescriptor) {
                    PBuilder builder = ((PEnumDescriptor)type).builder();
                    ((PEnumBuilder)builder).setByValue(val);
                    return builder.build();
                }
                return val;
            }
            case I64: {
                return in.expectLong();
            }
            case DOUBLE: {
                return in.expectDouble();
            }
            case STRING: 
            case BINARY: {
                int len = in.expectUInt32();
                byte[] data = in.expectBytes(len);
                if (type != null && type.getType() == PType.STRING) {
                    return new String(data, StandardCharsets.UTF_8);
                }
                return Binary.wrap((byte[])data);
            }
            case MESSAGE: {
                if (type == null) {
                    BinaryFormatUtils.consumeMessage(in, readStrict);
                    return null;
                }
                return BinaryFormatUtils.readMessage(in, (PMessageDescriptor)type, readStrict);
            }
            case MAP: {
                PBuilder<Map<Object, Object>> out;
                byte keyT = in.expectByte();
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor keyType = null;
                PDescriptor valueType = null;
                if (type != null) {
                    if (!type.getType().equals((Object)PType.MAP)) {
                        throw new SerializerException("Invalid type for map encoding: " + type, new Object[0]);
                    }
                    PMap mapType = (PMap)type;
                    keyType = mapType.keyDescriptor();
                    valueType = mapType.itemDescriptor();
                    out = mapType.builder();
                } else {
                    out = new PMap.ImmutableMapBuilder();
                }
                FieldInfo keyInfo = new FieldInfo(1, keyT);
                FieldInfo itemInfo = new FieldInfo(2, itemT);
                for (int i = 0; i < size; ++i) {
                    Object key = BinaryFormatUtils.readFieldValue(in, keyInfo, keyType, readStrict);
                    Object value = BinaryFormatUtils.readFieldValue(in, itemInfo, valueType, readStrict);
                    if (key != null && value != null) {
                        out.put(key, value);
                        continue;
                    }
                    if (!readStrict) continue;
                    throw new SerializerException("Null key or value in map.", new Object[0]);
                }
                return out.build();
            }
            case SET: {
                PBuilder<Set<Object>> out;
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor entryType = null;
                if (type != null) {
                    PSet setType = (PSet)type;
                    entryType = setType.itemDescriptor();
                    out = setType.builder();
                } else {
                    out = new PSet.ImmutableSetBuilder();
                }
                FieldInfo itemInfo = new FieldInfo(0, itemT);
                for (int i = 0; i < size; ++i) {
                    Object key = BinaryFormatUtils.readFieldValue(in, itemInfo, entryType, readStrict);
                    if (key != null) {
                        out.add((Object)key);
                        continue;
                    }
                    if (!readStrict) continue;
                    throw new SerializerException("Null value in set.", new Object[0]);
                }
                return out.build();
            }
            case LIST: {
                PBuilder<List<Object>> out;
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor entryType = null;
                if (type != null) {
                    PList listType = (PList)type;
                    entryType = listType.itemDescriptor();
                    out = listType.builder();
                } else {
                    out = new PList.ImmutableListBuilder();
                }
                FieldInfo itemInfo = new FieldInfo(0, itemT);
                for (int i = 0; i < size; ++i) {
                    Object key = BinaryFormatUtils.readFieldValue(in, itemInfo, entryType, readStrict);
                    if (key != null) {
                        out.add((Object)key);
                        continue;
                    }
                    if (!readStrict) continue;
                    throw new SerializerException("Null value in list.", new Object[0]);
                }
                return out.build();
            }
        }
        throw new SerializerException("unknown data type: " + fieldInfo.getType(), new Object[0]);
    }

    public static <Message extends PMessage<Message, Field>, Field extends PField> int writeMessage(BigEndianBinaryWriter writer, Message message) throws IOException {
        if (message instanceof BinaryWriter) {
            return ((BinaryWriter)((Object)message)).writeBinary(writer);
        }
        int len = 0;
        if (message instanceof PUnion) {
            Object field = ((PUnion)message).unionField();
            if (field != null) {
                len += BinaryFormatUtils.writeFieldSpec(writer, field.getDescriptor().getType().id, field.getKey());
                len += BinaryFormatUtils.writeFieldValue(writer, message.get(field.getKey()), field.getDescriptor());
            }
        } else {
            for (PField field : message.descriptor().getFields()) {
                if (!message.has(field.getKey())) continue;
                len += BinaryFormatUtils.writeFieldSpec(writer, field.getDescriptor().getType().id, field.getKey());
                len += BinaryFormatUtils.writeFieldValue(writer, message.get(field.getKey()), field.getDescriptor());
            }
        }
        return len += writer.writeUInt8((int)PType.STOP.id);
    }

    private static int writeFieldSpec(BigEndianBinaryWriter out, byte type, int key) throws IOException {
        out.writeByte(type);
        out.writeShort((short)key);
        return 3;
    }

    private static int writeFieldValue(BigEndianBinaryWriter out, Object value, PDescriptor descriptor) throws IOException {
        switch (descriptor.getType()) {
            case VOID: {
                return 0;
            }
            case BOOL: {
                return out.writeByte((Boolean)value != false ? (byte)1 : 0);
            }
            case BYTE: {
                return out.writeByte(((Byte)value).byteValue());
            }
            case I16: {
                return out.writeShort(((Short)value).shortValue());
            }
            case I32: {
                return out.writeInt(((Integer)value).intValue());
            }
            case I64: {
                return out.writeLong(((Long)value).longValue());
            }
            case DOUBLE: {
                return out.writeDouble(((Double)value).doubleValue());
            }
            case BINARY: {
                Binary binary = (Binary)value;
                int len = out.writeUInt32(binary.length());
                return len + out.writeBinary(binary);
            }
            case STRING: {
                Binary binary = Binary.wrap((byte[])value.toString().getBytes(StandardCharsets.UTF_8));
                int len = out.writeUInt32(binary.length());
                return len + out.writeBinary(binary);
            }
            case ENUM: {
                return out.writeInt(((PEnumValue)value).getValue());
            }
            case MAP: {
                Map map = (Map)value;
                PMap pMap = (PMap)descriptor;
                int len = out.writeByte(pMap.keyDescriptor().getType().id);
                len += out.writeByte(pMap.itemDescriptor().getType().id);
                len += out.writeUInt32(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    len += BinaryFormatUtils.writeFieldValue(out, entry.getKey(), pMap.keyDescriptor());
                    len += BinaryFormatUtils.writeFieldValue(out, entry.getValue(), pMap.itemDescriptor());
                }
                return len;
            }
            case SET: 
            case LIST: {
                Collection coll = (Collection)value;
                PContainer pSet = (PContainer)descriptor;
                int len = out.writeByte(pSet.itemDescriptor().getType().id);
                len += out.writeUInt32(coll.size());
                for (Object item : coll) {
                    len += BinaryFormatUtils.writeFieldValue(out, item, pSet.itemDescriptor());
                }
                return len;
            }
            case MESSAGE: {
                int size = BinaryFormatUtils.writeMessage(out, (PMessage)value);
                return size;
            }
        }
        throw new SerializerException("Unhandled field type: " + (Object)((Object)descriptor.getType()), new Object[0]);
    }

    public static class FieldInfo {
        private final int id;
        private final byte type;

        public FieldInfo(int id, byte type) {
            this.id = id;
            this.type = type;
        }

        public String toString() {
            return String.format("field(%d: %s)", new Object[]{this.id, PType.findById(this.type)});
        }

        public int getId() {
            return this.id;
        }

        public byte getType() {
            return this.type;
        }
    }
}

