/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.PrettySerializer;

public class PrettyPrinter {
    private static final PrettySerializer DEBUG_STRING_SERIALIZER = new PrettySerializer(false, false);

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> String debugString(Message message) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEBUG_STRING_SERIALIZER.serialize((OutputStream)baos, message);
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    @Nonnull
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message parseDebugString(String string, PMessageDescriptor<Message, Field> descriptor) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            return DEBUG_STRING_SERIALIZER.deserialize((InputStream)bais, descriptor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

