/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;

public class PMap<Key, Value>
extends PContainer<Map<Key, Value>> {
    private final PDescriptorProvider keyDescriptor;
    private final BuilderFactory<Key, Value> builderFactory;

    public PMap(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc, BuilderFactory<Key, Value> builderFactory) {
        super(itemDesc);
        this.keyDescriptor = keyDesc;
        this.builderFactory = builderFactory;
    }

    public PDescriptor keyDescriptor() {
        return this.keyDescriptor.descriptor();
    }

    @Override
    public String getName() {
        return "map<" + this.keyDescriptor().getName() + "," + this.itemDescriptor().getName() + ">";
    }

    @Override
    public String getQualifiedName(String programContext) {
        return "map<" + this.keyDescriptor().getQualifiedName(programContext) + "," + this.itemDescriptor().getQualifiedName(programContext) + ">";
    }

    @Override
    public PType getType() {
        return PType.MAP;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PMap)) {
            return false;
        }
        PMap other = (PMap)o;
        return other.itemDescriptor().equals(this.itemDescriptor()) && other.keyDescriptor().equals(this.keyDescriptor());
    }

    public int hashCode() {
        return PMap.class.hashCode() + this.itemDescriptor().hashCode() + this.keyDescriptor().hashCode();
    }

    public Builder<Key, Value> builder() {
        return this.builderFactory.builder();
    }

    public static <K, V> PContainerProvider<Map<K, V>, PMap<K, V>> provider(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc) {
        return PMap.provider(keyDesc, itemDesc, ImmutableMapBuilder::new);
    }

    public static <K extends Comparable<K>, V> PContainerProvider<Map<K, V>, PMap<K, V>> sortedProvider(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc) {
        return PMap.provider(keyDesc, itemDesc, ImmutableSortedMapBuilder::new);
    }

    public static <K, V> PContainerProvider<Map<K, V>, PMap<K, V>> orderedProvider(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc) {
        return PMap.provider(keyDesc, itemDesc, LinkedHashMapBuilder::new);
    }

    private static <K, V> PContainerProvider<Map<K, V>, PMap<K, V>> provider(PDescriptorProvider keyDesc, PDescriptorProvider itemDesc, BuilderFactory<K, V> builderFactory) {
        return new PContainerProvider<Map<K, V>, PMap<K, V>>(new PMap<K, V>(keyDesc, itemDesc, builderFactory));
    }

    public static class LinkedHashMapBuilder<K, V>
    implements Builder<K, V> {
        private final LinkedHashMap<K, V> builder = new LinkedHashMap();

        @Override
        public LinkedHashMapBuilder<K, V> put(K key, V value) {
            this.builder.put(key, value);
            return this;
        }

        @Override
        public LinkedHashMapBuilder<K, V> putAll(Map<K, V> map) {
            this.builder.putAll(map);
            return this;
        }

        @Override
        public LinkedHashMapBuilder<K, V> clear() {
            this.builder.clear();
            return this;
        }

        @Override
        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.builder);
        }
    }

    public static class ImmutableSortedMapBuilder<K extends Comparable, V>
    implements Builder<K, V> {
        private ImmutableSortedMap.Builder<K, V> builder = ImmutableSortedMap.naturalOrder();

        @Override
        public ImmutableSortedMapBuilder<K, V> put(K key, V value) {
            this.builder.put(key, value);
            return this;
        }

        @Override
        public ImmutableSortedMapBuilder<K, V> putAll(Map<K, V> map) {
            this.builder.putAll(map);
            return this;
        }

        @Override
        public ImmutableSortedMapBuilder<K, V> clear() {
            this.builder = ImmutableSortedMap.naturalOrder();
            return this;
        }

        @Override
        public Map<K, V> build() {
            return this.builder.build();
        }
    }

    public static class ImmutableMapBuilder<K, V>
    implements Builder<K, V> {
        private ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();

        @Override
        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.builder.put(key, value);
            return this;
        }

        @Override
        public ImmutableMapBuilder<K, V> putAll(Map<K, V> map) {
            this.builder.putAll(map);
            return this;
        }

        @Override
        public ImmutableMapBuilder<K, V> clear() {
            this.builder = ImmutableMap.builder();
            return this;
        }

        @Override
        public Map<K, V> build() {
            return this.builder.build();
        }
    }

    private static interface BuilderFactory<K, V>
    extends PBuilderFactory<Map<K, V>> {
        public Builder<K, V> builder();
    }

    public static interface Builder<K, V>
    extends PBuilder<Map<K, V>> {
        public Builder<K, V> put(K var1, V var2);

        public Builder<K, V> putAll(Map<K, V> var1);

        public Builder<K, V> clear();

        @Override
        public Map<K, V> build();
    }
}

