/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Objects;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PPrimitiveProvider;

public class PPrimitive
implements PDescriptor {
    public static final PPrimitive VOID = new PPrimitive(PType.VOID, null);
    public static final PPrimitive BOOL = new PPrimitive(PType.BOOL, false);
    public static final PPrimitive BYTE = new PPrimitive(PType.BYTE, (byte)0);
    public static final PPrimitive I16 = new PPrimitive(PType.I16, (short)0);
    public static final PPrimitive I32 = new PPrimitive(PType.I32, 0);
    public static final PPrimitive I64 = new PPrimitive(PType.I64, 0L);
    public static final PPrimitive DOUBLE = new PPrimitive(PType.DOUBLE, 0.0);
    public static final PPrimitive STRING = new PPrimitive(PType.STRING, null);
    public static final PPrimitive BINARY = new PPrimitive(PType.BINARY, null);
    private final PPrimitiveProvider mProvider;
    private final PType mType;
    private final Object mDefault;

    private PPrimitive(PType type, Object defValue) {
        this.mType = type;
        this.mProvider = new PPrimitiveProvider(this);
        this.mDefault = defValue;
    }

    public PPrimitiveProvider provider() {
        return this.mProvider;
    }

    @Override
    public String getProgramName() {
        return null;
    }

    @Override
    public String getName() {
        return this.mType.name;
    }

    @Override
    public String getQualifiedName(String programContext) {
        return this.mType.name;
    }

    public String toString() {
        return this.mType.name;
    }

    @Override
    public PType getType() {
        return this.mType;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mType, this.mDefault});
    }

    public Object getDefaultValue() {
        return this.mDefault;
    }

    public static PPrimitive findByName(String name) {
        switch (name) {
            case "void": {
                return VOID;
            }
            case "bool": {
                return BOOL;
            }
            case "byte": 
            case "i8": {
                return BYTE;
            }
            case "i16": {
                return I16;
            }
            case "i32": {
                return I32;
            }
            case "i64": {
                return I64;
            }
            case "double": {
                return DOUBLE;
            }
            case "string": {
                return STRING;
            }
            case "binary": {
                return BINARY;
            }
        }
        return null;
    }
}

