/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PRequirement;

public interface PField {
    public int getKey();

    public PRequirement getRequirement();

    default public PType getType() {
        return this.getDescriptor().getType();
    }

    public PDescriptor getDescriptor();

    public String getName();

    public boolean hasDefaultValue();

    public Object getDefaultValue();

    public static String toString(PField field) {
        StringBuilder builder = new StringBuilder();
        builder.append(field.getClass().getSimpleName().replaceAll("[$]", ".")).append("(").append(field.getKey()).append(": ");
        if (field.getRequirement() != PRequirement.DEFAULT) {
            builder.append(field.getRequirement().label).append(" ");
        }
        builder.append(field.getDescriptor().getQualifiedName()).append(' ').append(field.getName()).append(')');
        return builder.toString();
    }
}

