/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PField;

public abstract class PStructDescriptor<T extends PMessage<T, F>, F extends PField>
extends PDeclaredDescriptor<T> {
    private final PMessageBuilderFactory<T, F> factory;
    private final boolean compactible;
    private final boolean simple;

    public PStructDescriptor(String programName, String name, PMessageBuilderFactory<T, F> factory, boolean simple, boolean compactible) {
        super(programName, name);
        this.factory = factory;
        this.simple = simple;
        this.compactible = compactible;
    }

    public abstract F[] getFields();

    public abstract F getField(String var1);

    public abstract F getField(int var1);

    public boolean isCompactible() {
        return this.compactible;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public PMessageVariant getVariant() {
        return PMessageVariant.STRUCT;
    }

    @Override
    public PType getType() {
        return PType.MESSAGE;
    }

    public PMessageBuilder<T, F> builder() {
        return this.factory.builder();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PStructDescriptor)) {
            return false;
        }
        PStructDescriptor other = (PStructDescriptor)o;
        if (!this.getQualifiedName().equals(other.getQualifiedName()) || !this.getVariant().equals((Object)other.getVariant()) || this.getFields().length != other.getFields().length) {
            return false;
        }
        for (PField field : this.getFields()) {
            if (field.equals(other.getField(field.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = PStructDescriptor.class.hashCode() + this.getQualifiedName().hashCode() + this.getVariant().hashCode();
        for (PField field : this.getFields()) {
            hash += field.hashCode();
        }
        return hash;
    }

    protected PMessageBuilderFactory<T, F> getFactoryInternal() {
        return this.factory;
    }
}

