/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.util.HashMap;
import java.util.Map;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.FastBinarySerializer;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;

public class DefaultSerializerProvider
implements SerializerProvider {
    private final Map<String, Serializer> serializerMap;
    private final String defaultContentType;

    public DefaultSerializerProvider() {
        this("application/vnd.apache.thrift.binary");
    }

    public DefaultSerializerProvider(String defaultContentType) {
        this.defaultContentType = defaultContentType;
        this.serializerMap = new HashMap<String, Serializer>();
        this.register(new BinarySerializer(), "application/vnd.apache.thrift.binary", "application/x-thrift");
        this.register(new FastBinarySerializer(), "application/vnd.morimekta.providence.binary");
        this.register(new JsonSerializer(), "application/vnd.morimekta.providence.json", "application/json");
    }

    @Override
    public Serializer getSerializer(String mimeType) {
        return this.serializerMap.get(mimeType);
    }

    @Override
    public Serializer getDefault() {
        return this.getSerializer(this.defaultContentType);
    }

    protected void register(Serializer serializer, String ... mimeTypes) {
        for (String mimeType : mimeTypes) {
            this.serializerMap.put(mimeType, serializer);
        }
    }
}

