/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util.pretty;

import java.util.regex.Pattern;
import net.morimekta.util.Slice;
import net.morimekta.util.Strings;

public class Token
extends Slice {
    public static final char kMessageStart = '{';
    public static final char kMessageEnd = '}';
    public static final char kKeyValueSep = ':';
    public static final char kFieldValueSep = '=';
    public static final char kMethodStart = '(';
    public static final char kMethodEnd = ')';
    public static final char kListStart = '[';
    public static final char kListEnd = ']';
    public static final char kLineSep1 = ',';
    public static final char kLineSep2 = ';';
    public static final char kIdentifierSep = '.';
    public static final char kLiteralEscape = '\\';
    public static final char kLiteralQuote = '\'';
    public static final char kLiteralDoubleQuote = '\"';
    public static final char kShellComment = '#';
    public static final String B64 = "b64";
    public static final String HEX = "hex";
    public static final String kSymbols = "{}:=()<>,;#[]";
    private static final Pattern RE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_DOUBLE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_REFERENCE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*([.][_a-zA-Z][_a-zA-Z0-9]*)*");
    private static final Pattern RE_INTEGER = Pattern.compile("-?(0|[1-9][0-9]*|0[0-7]+|0x[0-9a-fA-F]+)");
    private static final Pattern RE_REAL = Pattern.compile("-?(\\.[0-9]+|[1-9][0-9]*\\.[0-9]*)([eE][+-]?[0-9][0-9]*)?");
    private final int lineNo;
    private final int linePos;

    public Token(byte[] fb, int off, int len, int lineNo, int linePos) {
        super(fb, off, len);
        this.lineNo = lineNo;
        this.linePos = linePos;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public boolean isSymbol(char symbol) {
        return this.len == 1 && this.fb[this.off] == symbol;
    }

    public boolean isStringLiteral() {
        return this.length() > 1 && this.charAt(0) == '\"' && this.charAt(-1) == '\"';
    }

    public boolean isIdentifier() {
        return RE_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isQualifiedIdentifier() {
        return RE_QUALIFIED_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isDoubleQualifiedIdentifier() {
        return RE_DOUBLE_QUALIFIED_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isReferenceIdentifier() {
        return RE_REFERENCE_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isInteger() {
        return RE_INTEGER.matcher(this.asString()).matches();
    }

    public boolean isReal() {
        return RE_REAL.matcher(this.asString()).matches();
    }

    public String decodeLiteral() {
        return this.decodeLiteral(false);
    }

    public String decodeLiteral(boolean strict) {
        String tmp = this.substring(1, -1).asString();
        int l = tmp.length();
        StringBuilder out = new StringBuilder(l);
        boolean esc = false;
        for (int i = 0; i < l; ++i) {
            if (esc) {
                esc = false;
                char ch = tmp.charAt(i);
                switch (ch) {
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        out.append(ch);
                        break;
                    }
                    case 'u': {
                        int cp;
                        String n;
                        if (l < i + 5) {
                            out.append('?');
                        } else {
                            n = tmp.substring(i + 1, i + 5);
                            try {
                                cp = Integer.parseInt(n, 16);
                                out.append((char)cp);
                            }
                            catch (NumberFormatException e) {
                                out.append('?');
                            }
                        }
                        i += 4;
                        break;
                    }
                    case '0': 
                    case '1': {
                        int cp;
                        String n;
                        if (l < i + 3) {
                            out.append('?');
                        } else {
                            n = tmp.substring(i, i + 2);
                            try {
                                cp = Integer.parseInt(n, 8);
                                out.append((char)cp);
                            }
                            catch (NumberFormatException e) {
                                out.append('?');
                            }
                        }
                        i += 2;
                        break;
                    }
                    default: {
                        if (strict) {
                            throw new IllegalArgumentException("Invalid escaped char: '\\" + Strings.escape((CharSequence)String.valueOf(ch)) + "'");
                        }
                        out.append('?');
                        break;
                    }
                }
                continue;
            }
            if (tmp.charAt(i) == '\\') {
                esc = true;
                continue;
            }
            if (tmp.charAt(i) < ' ' || tmp.charAt(1) == '\u007f') {
                if (strict) {
                    throw new IllegalArgumentException("Unescaped string char: '" + Strings.escape((CharSequence)String.valueOf(tmp.charAt(i))) + "'");
                }
                out.append('?');
                continue;
            }
            out.append(tmp.charAt(i));
        }
        return out.toString();
    }

    public String toString() {
        return String.format("Token('%s',%d:%d-%d)", this.asString(), this.lineNo, this.linePos, this.linePos + this.len);
    }
}

