/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import com.google.common.base.MoreObjects;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.serializer.ApplicationExceptionType;
import net.morimekta.util.Stringable;

public class SerializerException
extends Exception
implements Stringable {
    private static final long serialVersionUID = 1442914425369642982L;
    private String methodName;
    private PServiceCallType callType;
    private int sequenceNo;
    private ApplicationExceptionType exceptionType = ApplicationExceptionType.PROTOCOL_ERROR;

    public SerializerException(String format, Object ... args) {
        super(args.length == 0 ? format : String.format(format, args));
    }

    public SerializerException(Throwable cause, String format, Object ... args) {
        super(args.length == 0 ? format : String.format(format, args), cause);
    }

    public String getMethodName() {
        return this.methodName == null ? "" : this.methodName;
    }

    public PServiceCallType getCallType() {
        return this.callType;
    }

    public int getSequenceNo() {
        return this.sequenceNo;
    }

    public ApplicationExceptionType getExceptionType() {
        return this.exceptionType;
    }

    public SerializerException setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public SerializerException setCallType(PServiceCallType callType) {
        this.callType = callType;
        return this;
    }

    public SerializerException setSequenceNo(int sequenceNo) {
        this.sequenceNo = sequenceNo;
        return this;
    }

    public SerializerException setExceptionType(ApplicationExceptionType type) {
        this.exceptionType = type;
        return this;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().addValue((Object)this.getMessage()).add("method", (Object)this.methodName).add("type", (Object)this.callType).add("seq", this.sequenceNo).toString();
    }

    public String asString() {
        if (this.methodName != null) {
            return "Error in " + this.methodName + ": " + this.getMessage();
        }
        return "Error: " + this.getMessage();
    }
}

