/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.mio;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.streams.MessageStreams;

public class FileMessageWriter
implements MessageWriter,
Closeable {
    private final File file;
    private final Serializer serializer;
    private final boolean append;
    private OutputStream out;

    public FileMessageWriter(File file, Serializer serializer) {
        this(file, serializer, false);
    }

    public FileMessageWriter(File file, Serializer serializer, boolean append) {
        this.file = file;
        this.serializer = serializer;
        this.append = append;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int write(Message message) throws IOException, SerializerException {
        int ret = this.serializer.serialize(this.getOutputStream(), message);
        if (!this.serializer.binaryProtocol()) {
            this.out.write(MessageStreams.READABLE_ENTRY_SEP);
        }
        return ret;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int write(PServiceCall<Message, Field> call) throws IOException, SerializerException {
        int ret = this.serializer.serialize(this.getOutputStream(), call);
        if (!this.serializer.binaryProtocol()) {
            this.out.write(MessageStreams.READABLE_ENTRY_SEP);
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                this.out.flush();
                this.out.close();
            }
            finally {
                this.out = null;
            }
        }
    }

    private OutputStream getOutputStream() throws FileNotFoundException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(new FileOutputStream(this.file, this.append));
        }
        return this.out;
    }
}

