/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptorProvider;

public class PSet<Item>
extends PContainer<Set<Item>> {
    private final BuilderFactory<Item> builderFactory;

    public PSet(PDescriptorProvider itemType, BuilderFactory<Item> builderFactory) {
        super(itemType);
        this.builderFactory = builderFactory;
    }

    @Override
    public String getName() {
        return "set<" + this.itemDescriptor().getName() + ">";
    }

    @Override
    public String getQualifiedName(String packageName) {
        return "set<" + this.itemDescriptor().getQualifiedName(packageName) + ">";
    }

    @Override
    public PType getType() {
        return PType.SET;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PSet)) {
            return false;
        }
        PSet other = (PSet)o;
        return other.itemDescriptor().equals(this.itemDescriptor());
    }

    public int hashCode() {
        return PSet.class.hashCode() + this.itemDescriptor().hashCode();
    }

    @Override
    public Builder<Item> builder() {
        return this.builderFactory.builder();
    }

    public static <I> PContainerProvider<Set<I>, PSet<I>> provider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, ImmutableSetBuilder::new);
    }

    public static <I extends Comparable<I>> PContainerProvider<Set<I>, PSet<I>> sortedProvider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, ImmutableSortedSetBuilder::new);
    }

    public static <I extends Comparable<I>> PContainerProvider<Set<I>, PSet<I>> orderedProvider(PDescriptorProvider itemDesc) {
        return PSet.provider(itemDesc, LinkedHashSetBuilder::new);
    }

    private static <I> PContainerProvider<Set<I>, PSet<I>> provider(PDescriptorProvider itemDesc, BuilderFactory<I> builderFactory) {
        return new PContainerProvider<Set<I>, PSet<I>>(new PSet<I>(itemDesc, builderFactory));
    }

    public static class LinkedHashSetBuilder<I>
    implements Builder<I> {
        private final LinkedHashSet<I> builder = new LinkedHashSet();

        @Override
        public LinkedHashSetBuilder<I> add(I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        public LinkedHashSetBuilder<I> addAll(Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        public LinkedHashSetBuilder<I> clear() {
            this.builder.clear();
            return this;
        }

        @Override
        public Set<I> build() {
            return Collections.unmodifiableSet(this.builder);
        }
    }

    public static class ImmutableSortedSetBuilder<I extends Comparable<I>>
    implements Builder<I> {
        private ImmutableSortedSet.Builder<I> builder = ImmutableSortedSet.naturalOrder();

        @Override
        public ImmutableSortedSetBuilder<I> add(I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        public ImmutableSortedSetBuilder<I> addAll(Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        public ImmutableSortedSetBuilder<I> clear() {
            this.builder = ImmutableSortedSet.naturalOrder();
            return this;
        }

        @Override
        public Set<I> build() {
            return this.builder.build();
        }
    }

    public static class ImmutableSetBuilder<I>
    implements Builder<I> {
        private ImmutableSet.Builder<I> builder = ImmutableSet.builder();

        @Override
        public ImmutableSetBuilder<I> add(I value) {
            this.builder.add(value);
            return this;
        }

        @Override
        public ImmutableSetBuilder<I> addAll(Collection<I> items) {
            this.builder.addAll(items);
            return this;
        }

        @Override
        public ImmutableSetBuilder<I> clear() {
            this.builder = ImmutableSet.builder();
            return this;
        }

        @Override
        public Set<I> build() {
            return this.builder.build();
        }
    }

    private static interface BuilderFactory<I>
    extends PBuilderFactory<Set<I>> {
        @Override
        public Builder<I> builder();
    }

    public static interface Builder<I>
    extends PBuilder<Set<I>> {
        public Builder<I> add(I var1);

        public Builder<I> addAll(Collection<I> var1);

        public Builder<I> clear();

        @Override
        public Set<I> build();
    }
}

