/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.ApplicationException;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Binary;
import net.morimekta.util.Slice;
import net.morimekta.util.Strings;
import net.morimekta.util.io.CountingOutputStream;
import net.morimekta.util.io.IOUtils;
import net.morimekta.util.io.IndentedPrintWriter;

public class PrettySerializer
extends Serializer {
    public static final String MIME_TYPE = "text/plain";
    private static final String INDENT = "  ";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String LIST_SEP = ",";
    private final String indent;
    private final String space;
    private final String newline;
    private final String entrySep;
    private final boolean encloseOuther;
    private final boolean repeatedListEntries;

    public PrettySerializer() {
        this(INDENT, SPACE, NEWLINE, LIST_SEP, true, false);
    }

    public PrettySerializer(String indent, String space, String newline, String entrySep, boolean encloseOuther, boolean repeatedListEntries) {
        this.indent = indent;
        this.space = space;
        this.newline = newline;
        this.entrySep = entrySep;
        this.encloseOuther = encloseOuther;
        this.repeatedListEntries = repeatedListEntries;
    }

    @Override
    public <T extends PMessage<T>> int serialize(OutputStream out, T message) {
        CountingOutputStream cout = new CountingOutputStream(out);
        IndentedPrintWriter builder = new IndentedPrintWriter((OutputStream)cout, this.indent, this.newline);
        this.appendMessage(builder, message, this.encloseOuther);
        builder.flush();
        return cout.getByteCount();
    }

    @Override
    public <T extends PMessage<T>> int serialize(OutputStream out, PServiceCall<T> call) throws IOException, SerializerException {
        CountingOutputStream cout = new CountingOutputStream(out);
        IndentedPrintWriter builder = new IndentedPrintWriter((OutputStream)cout, this.indent, this.newline);
        builder.format("%d: %s %s", new Object[]{call.getSequence(), call.getType().toString(), call.getMethod()}).begin(this.indent + this.indent);
        this.appendMessage(builder, (PMessage<?>)call.getMessage(), true);
        builder.end().newline().flush();
        return cout.getByteCount();
    }

    @Override
    public <T extends PMessage<T>> PServiceCall<T> deserialize(InputStream input, PService service) throws SerializerException, IOException {
        ApplicationException message;
        PServiceCallType callType;
        Tokenizer tokenizer = new Tokenizer(input, false);
        Token token = tokenizer.expect("Sequence or type");
        int sequence = 0;
        if (token.isInteger()) {
            sequence = (int)token.parseInteger();
            tokenizer.expectSymbol("Sequence type sep", ':');
            token = tokenizer.expectIdentifier("Call Type");
        }
        if ((callType = PServiceCallType.findByName(token.asString())) == null) {
            throw new SerializerException("No such call type " + token.asString(), new Object[0]);
        }
        String methodName = tokenizer.expectIdentifier("Method name").asString();
        PServiceMethod method = service.getMethod(methodName);
        if (method == null) {
            throw new SerializerException("No such method " + methodName + " on service " + service.getQualifiedName(null), new Object[0]);
        }
        tokenizer.expectSymbol("Call params start", '(');
        tokenizer.expectSymbol("Message encloser", '{');
        switch (callType) {
            case CALL: 
            case ONEWAY: {
                message = this.readMessage(tokenizer, method.getRequestType(), true);
                break;
            }
            case REPLY: {
                message = this.readMessage(tokenizer, method.getResponseType(), true);
                break;
            }
            case EXCEPTION: {
                message = this.readMessage(tokenizer, ApplicationException.kDescriptor, true);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable code reached");
            }
        }
        tokenizer.expectSymbol("Call params closing", ')');
        return new PServiceCall<ApplicationException>(methodName, callType, sequence, message);
    }

    @Override
    public <T extends PMessage<T>, TF extends PField> T deserialize(InputStream input, PStructDescriptor<T, TF> descriptor) throws IOException, SerializerException {
        Tokenizer tokenizer = new Tokenizer(input, this.encloseOuther);
        Token first = tokenizer.peek();
        if (first != null && first.isSymbol('{')) {
            tokenizer.next();
            return this.readMessage(tokenizer, descriptor, true);
        }
        return this.readMessage(tokenizer, descriptor, false);
    }

    private <T extends PMessage<T>, TF extends PField> T readMessage(Tokenizer tokenizer, PStructDescriptor<T, TF> descriptor, boolean requireEnd) throws IOException, SerializerException {
        PBuilder builder = descriptor.builder();
        while (true) {
            Token t = tokenizer.next();
            if (!requireEnd ? t == null : t != null && t.isSymbol('}')) break;
            if (t == null) {
                throw new SerializerException("Unexpected end of stream", new Object[0]);
            }
            if (!t.isIdentifier()) {
                throw new SerializerException("", new Object[0]);
            }
            TF field = descriptor.getField(t.asString());
            if (field == null) {
                throw new SerializerException("No such field on " + descriptor.getQualifiedName(null) + ": " + t.asString(), new Object[0]);
            }
            tokenizer.expectSymbol("field value separator", ':');
            if (field.getType() == PType.LIST) {
                t = tokenizer.peek("list field value");
                if (t.isSymbol('[')) {
                    ((PMessageBuilder)builder).set(field.getKey(), this.readFieldValue(tokenizer, field.getDescriptor()));
                } else {
                    ((PMessageBuilder)builder).addTo(field.getKey(), this.readFieldValue(tokenizer, ((PList)field.getDescriptor()).itemDescriptor()));
                }
            } else {
                ((PMessageBuilder)builder).set(field.getKey(), this.readFieldValue(tokenizer, field.getDescriptor()));
            }
            if ((t = tokenizer.peek()) == null || !t.isSymbol(',') && !t.isSymbol(';')) continue;
            tokenizer.next();
        }
        return (T)((PMessage)builder.build());
    }

    private Object readFieldValue(Tokenizer tokenizer, PDescriptor descriptor) throws IOException, SerializerException {
        switch (descriptor.getType()) {
            case BOOL: {
                Token t = tokenizer.expect("boolean value");
                switch (t.asString().toLowerCase()) {
                    case "1": 
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return true;
                    }
                    case "0": 
                    case "f": 
                    case "false": 
                    case "n": 
                    case "no": {
                        return false;
                    }
                }
                throw new SerializerException("Invalid boolean value " + t.asString(), new Object[0]);
            }
            case BYTE: {
                Token t = tokenizer.expect("byte value");
                if (t.isInteger()) {
                    long val = t.parseInteger();
                    if (val > 127L || val < -128L) {
                        throw new SerializerException("Byte value out of bounds: " + t.asString(), new Object[0]);
                    }
                    return (byte)val;
                }
                throw new SerializerException("Invalid byte value: " + t.asString(), new Object[0]);
            }
            case I16: {
                Token t = tokenizer.expect("byte value");
                if (t.isInteger()) {
                    long val = t.parseInteger();
                    if (val > 32767L || val < -32768L) {
                        throw new SerializerException("Short value out of bounds: " + t.asString(), new Object[0]);
                    }
                    return (short)val;
                }
                throw new SerializerException("Invalid byte value: " + t.asString(), new Object[0]);
            }
            case I32: {
                Token t = tokenizer.expect("byte value");
                if (t.isInteger()) {
                    long val = t.parseInteger();
                    if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                        throw new SerializerException("Integer value out of bounds: " + t.asString(), new Object[0]);
                    }
                    return (int)val;
                }
                throw new SerializerException("Invalid byte value: " + t.asString(), new Object[0]);
            }
            case I64: {
                Token t = tokenizer.expect("byte value");
                if (t.isInteger()) {
                    return t.parseInteger();
                }
                throw new SerializerException("Invalid byte value: " + t.asString(), new Object[0]);
            }
            case DOUBLE: {
                Token t = tokenizer.expect("byte value");
                try {
                    return t.parseDouble();
                }
                catch (NumberFormatException nfe) {
                    throw new SerializerException(nfe, nfe.getMessage(), new Object[0]);
                }
            }
            case STRING: {
                Token t = tokenizer.expectStringLiteral("string value");
                return t.decodeLiteral();
            }
            case BINARY: {
                tokenizer.expectSymbol("binary value", '[');
                return tokenizer.readBinaryUntil(']');
            }
            case ENUM: {
                Token t = tokenizer.expectIdentifier("enum value");
                PBuilder b = ((PEnumDescriptor)descriptor).builder();
                ((PEnumBuilder)b).setByName(t.asString());
                if (!((PEnumBuilder)b).isValid()) {
                    throw new SerializerException("No such " + descriptor.getQualifiedName(null) + " value " + t.asString(), new Object[0]);
                }
                return b.build();
            }
            case MESSAGE: {
                tokenizer.expectSymbol("message start", '{');
                return this.readMessage(tokenizer, (PStructDescriptor)descriptor, true);
            }
            case MAP: {
                PMap pMap = (PMap)descriptor;
                PDescriptor kDesc = pMap.keyDescriptor();
                PDescriptor iDesc = pMap.itemDescriptor();
                PBuilder builder = pMap.builder();
                tokenizer.expectSymbol("map start", '{');
                if (tokenizer.peek("map end or value").isSymbol('}')) {
                    tokenizer.next();
                } else {
                    while (true) {
                        Object key = this.readFieldValue(tokenizer, kDesc);
                        tokenizer.expectSymbol("mep kv sep", ':');
                        Object value = this.readFieldValue(tokenizer, iDesc);
                        builder.put(key, value);
                        Token t = tokenizer.peek("map sep, end or value");
                        if (t.isSymbol(',') || t.isSymbol(';')) {
                            tokenizer.next();
                            continue;
                        }
                        if (t.isSymbol('}')) break;
                    }
                    tokenizer.next();
                }
                return builder.build();
            }
            case LIST: {
                PList pList = (PList)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PBuilder builder = pList.builder();
                tokenizer.expectSymbol("list start", '[');
                if (tokenizer.peek("empty list").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    while (true) {
                        Object value = this.readFieldValue(tokenizer, iDesc);
                        builder.add(value);
                        Token t = tokenizer.peek("list sep, end or value");
                        if (t.isSymbol(',') || t.isSymbol(';')) {
                            tokenizer.next();
                            continue;
                        }
                        if (t.isSymbol(']')) break;
                    }
                    tokenizer.next();
                }
                return builder.build();
            }
            case SET: {
                PSet pList = (PSet)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PBuilder builder = pList.builder();
                tokenizer.expectSymbol("set start", '[');
                if (tokenizer.peek("empty set").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    while (true) {
                        Object value = this.readFieldValue(tokenizer, iDesc);
                        builder.add(value);
                        Token t = tokenizer.peek("set sep, end or value");
                        if (t.isSymbol(',') || t.isSymbol(';')) {
                            tokenizer.next();
                            continue;
                        }
                        if (t.isSymbol(']')) break;
                    }
                    tokenizer.next();
                }
                return builder.build();
            }
        }
        return null;
    }

    @Override
    public boolean binaryProtocol() {
        return false;
    }

    @Override
    public String mimeType() {
        return MIME_TYPE;
    }

    private void appendMessage(IndentedPrintWriter builder, PMessage<?> message, boolean enclose) {
        PDescriptor type = message.descriptor();
        if (enclose) {
            builder.append((CharSequence)"{").begin();
        }
        if (message instanceof PUnion) {
            PField field = ((PUnion)message).unionField();
            if (field != null) {
                Object o = message.get(field.getKey());
                if (enclose) {
                    builder.appendln();
                }
                builder.append((CharSequence)field.getName()).append((CharSequence)":").append((CharSequence)this.space);
                this.appendTypedValue(builder, field.getDescriptor(), o);
            }
        } else {
            boolean first = true;
            for (PField field : type.getFields()) {
                if (!message.has(field.getKey())) continue;
                if (first) {
                    first = false;
                    if (enclose) {
                        builder.appendln();
                    }
                } else {
                    builder.append((CharSequence)this.entrySep).appendln();
                }
                Object o = message.get(field.getKey());
                if (field.getType() == PType.LIST && this.repeatedListEntries) {
                    PList list = (PList)field.getDescriptor();
                    Collection coll = (Collection)o;
                    boolean firstItem = true;
                    for (Object v : coll) {
                        if (firstItem) {
                            firstItem = false;
                        } else {
                            builder.appendln();
                        }
                        builder.append((CharSequence)field.getName()).append((CharSequence)":").append((CharSequence)this.space);
                        this.appendTypedValue(builder, list.itemDescriptor(), v);
                    }
                    continue;
                }
                builder.append((CharSequence)field.getName()).append((CharSequence)":").append((CharSequence)this.space);
                this.appendTypedValue(builder, field.getDescriptor(), o);
            }
        }
        if (enclose) {
            builder.end().appendln((CharSequence)"}");
        }
    }

    private void appendTypedValue(IndentedPrintWriter writer, PDescriptor descriptor, Object o) {
        switch (descriptor.getType()) {
            case LIST: 
            case SET: {
                PContainer containerType = (PContainer)descriptor;
                PDescriptor itemType = containerType.itemDescriptor();
                Collection collection = (Collection)o;
                PPrimitive primitive = PPrimitive.findByName(itemType.getName());
                if (primitive != null && primitive != PPrimitive.STRING && primitive != PPrimitive.BINARY && collection.size() <= 10) {
                    writer.append((CharSequence)"[");
                    boolean first = true;
                    for (Object i : collection) {
                        if (first) {
                            first = false;
                        } else {
                            writer.append(',').append((CharSequence)this.space);
                        }
                        this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                    }
                    writer.append((CharSequence)"]");
                    break;
                }
                writer.append((CharSequence)"[").begin();
                boolean first = true;
                for (Object i : collection) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',');
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.end().appendln((CharSequence)"]");
                break;
            }
            case MAP: {
                PMap mapType = (PMap)descriptor;
                Map map = (Map)o;
                writer.append((CharSequence)"{").begin();
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append((CharSequence)this.entrySep);
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, mapType.keyDescriptor(), entry.getKey());
                    writer.append((CharSequence)":").append((CharSequence)this.space);
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.end().appendln((CharSequence)"}");
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)o;
                this.appendMessage(writer, message, true);
                break;
            }
            default: {
                this.appendPrimitive(writer, o);
            }
        }
    }

    private void appendPrimitive(IndentedPrintWriter writer, Object o) {
        if (o instanceof PEnumValue) {
            writer.print(((PEnumValue)o).asString());
        } else if (o instanceof CharSequence) {
            writer.print('\"');
            writer.print(Strings.escape((CharSequence)((CharSequence)o)));
            writer.print('\"');
        } else if (o instanceof Binary) {
            Binary b = (Binary)o;
            writer.append('[').append((CharSequence)b.toBase64()).append(']');
        } else if (o instanceof Boolean) {
            writer.print(((Boolean)o).booleanValue());
        } else if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
            writer.print(Strings.escape((CharSequence)o.toString()));
        } else if (o instanceof Double) {
            Double d = (Double)o;
            if (d == (double)d.longValue()) {
                writer.print(d.longValue());
            } else if (d > 5119.0 || 1.0 / d > 640.0) {
                writer.print(new DecimalFormat("0.#########E0").format(d));
            } else {
                writer.print(d.doubleValue());
            }
        } else {
            throw new IllegalArgumentException("Unknown primitive type class " + o.getClass().getSimpleName());
        }
    }

    public static class Tokenizer
    extends InputStream {
        private final byte[] buffer;
        private int readOffset;
        private int lineNo;
        private int linePos;
        private Token nextToken;

        public Tokenizer(InputStream in, boolean enclosedContent) throws IOException {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            if (enclosedContent) {
                int r;
                int stack = 0;
                int literal = 0;
                boolean escaped = false;
                boolean comment = false;
                while ((r = in.read()) >= 0) {
                    if (comment) {
                        if (r != 10 && r != 13) continue;
                        tmp.write(r);
                        comment = false;
                        continue;
                    }
                    if (literal != 0) {
                        if (escaped) {
                            escaped = false;
                        } else if (r == literal) {
                            literal = 0;
                            escaped = false;
                        } else if (r == 92) {
                            escaped = true;
                        }
                    } else if (r != 32 && r != 9 && r != 13 && r != 10) {
                        if (r == 34 || r == 39) {
                            literal = (char)r;
                        } else {
                            if (r == 35) {
                                comment = true;
                                continue;
                            }
                            if (r == 125) {
                                if (--stack <= 0) {
                                    tmp.write(r);
                                    break;
                                }
                            } else if (r == 123) {
                                ++stack;
                            } else if (stack == 0) {
                                stack = 1;
                            }
                        }
                    }
                    tmp.write(r);
                }
            } else {
                IOUtils.copy((InputStream)in, (OutputStream)tmp);
            }
            this.buffer = tmp.toByteArray();
            this.readOffset = -1;
            this.lineNo = 1;
            this.linePos = -1;
        }

        @Override
        public int read() {
            if (++this.readOffset >= this.buffer.length) {
                this.readOffset = this.buffer.length;
                return -1;
            }
            int ret = this.buffer[this.readOffset];
            if (ret == 10) {
                ++this.lineNo;
                this.linePos = -1;
            } else {
                ++this.linePos;
            }
            return ret > 0 ? ret : 256 + ret;
        }

        private void unread() {
            if (this.readOffset == this.buffer.length) {
                --this.readOffset;
                return;
            }
            if (this.buffer[this.readOffset--] == 10) {
                --this.lineNo;
            } else {
                --this.linePos;
            }
        }

        public Token expect(String message) throws IOException, SerializerException {
            if (!this.hasNext()) {
                throw new SerializerException("Unexpected end of file, while %s", message);
            }
            Token next = this.nextToken;
            this.nextToken = null;
            return next;
        }

        public Token peek(String message) throws IOException, SerializerException {
            if (!this.hasNext()) {
                throw new SerializerException("Unexpected end of file, while %s", message);
            }
            return this.nextToken;
        }

        public Token peek() throws IOException, SerializerException {
            this.hasNext();
            return this.nextToken;
        }

        public char expectSymbol(String message, char ... symbols) throws IOException, SerializerException {
            if (!this.hasNext()) {
                throw new SerializerException("Unexpected end of file, expected one of ['%s'] while %s", Strings.escape((CharSequence)Strings.join((String)"', '", (char[])symbols)), message);
            }
            for (char symbol : symbols) {
                if (!this.nextToken.isSymbol(symbol)) continue;
                this.nextToken = null;
                return symbol;
            }
            throw new SerializerException("Expected one of ['%s'], but found '%s' while %s", Strings.escape((CharSequence)Strings.join((String)"', '", (char[])symbols)), Strings.escape((CharSequence)this.nextToken.asString()), message);
        }

        public Token expectIdentifier(String message) throws IOException, SerializerException {
            if (!this.hasNext()) {
                throw new SerializerException("Unexpected end of file, while %s", message);
            }
            if (this.nextToken.isIdentifier()) {
                Token next = this.nextToken;
                this.nextToken = null;
                return next;
            }
            throw new SerializerException("Expected identifier, but found '%s' while %s", Strings.escape((CharSequence)this.nextToken.asString()), message);
        }

        public Token expectStringLiteral(String message) throws IOException, SerializerException {
            if (!this.hasNext()) {
                throw new SerializerException("Unexpected end of file, while %s", message);
            }
            if (this.nextToken.isStringLiteral()) {
                Token next = this.nextToken;
                this.nextToken = null;
                return next;
            }
            throw new SerializerException("Expected string literal, but found '%s' while %s", Strings.escape((CharSequence)this.nextToken.asString()), message);
        }

        public boolean hasNext() throws IOException, SerializerException {
            if (this.nextToken == null) {
                this.nextToken = this.nextInternal();
            }
            return this.nextToken != null;
        }

        public Token next() throws IOException, SerializerException {
            if (this.nextToken != null) {
                Token tmp = this.nextToken;
                this.nextToken = null;
                return tmp;
            }
            return this.nextInternal();
        }

        private Token nextStringLiteral(int startQuote) throws SerializerException {
            int startOffset = this.readOffset;
            int startLinePos = this.linePos;
            boolean escaped = false;
            while (true) {
                int r;
                if ((r = this.read()) < 32 || r == 127) {
                    int pos = startOffset - this.readOffset;
                    if (r == -1) {
                        throw new SerializerException("Unexpected end of stream in string: line" + this.lineNo + " pos " + startLinePos + pos, new Object[0]);
                    }
                    throw new SerializerException("Invalid string literal char: " + r + " at line " + this.lineNo + " pos " + startLinePos + pos, new Object[0]);
                }
                if (escaped) {
                    escaped = false;
                    continue;
                }
                if (r == 92) {
                    escaped = true;
                    continue;
                }
                if (startQuote == r) break;
            }
            return new Token(this.buffer, startOffset, this.readOffset - startOffset + 1, this.lineNo, startLinePos);
        }

        private Token nextInternal() throws IOException, SerializerException {
            int r;
            int startOffset = this.readOffset;
            while ((r = this.read()) != -1) {
                if (r == 32 || r == 9 || r == 13 || r == 10) continue;
                if (r == 35) {
                    while ((r = this.read()) != -1 && r != 10 && r != 13) {
                    }
                    continue;
                }
                startOffset = this.readOffset;
                break;
            }
            if (r < 0) {
                return null;
            }
            if ("{}:=()<>,;#[]".indexOf(r) >= 0) {
                return new Token(this.buffer, startOffset, 1, this.lineNo, this.linePos);
            }
            if (r == 39 || r == 34) {
                return this.nextStringLiteral(r);
            }
            if (r == 46 || r == 45 || r >= 48 && r <= 57) {
                return this.nextNumber(r);
            }
            if (r == 95 || r >= 97 && r <= 122 || r >= 65 && r <= 90) {
                return this.nextIdentifier();
            }
            throw new SerializerException(String.format("Unknown token initiator: %c, line %d, pos %d", r, this.lineNo, this.linePos), new Object[0]);
        }

        private Token nextNumber(int lastByte) throws SerializerException {
            int startLinePos = this.linePos;
            int startOffset = this.readOffset;
            int len = 0;
            if (lastByte == 45) {
                lastByte = this.read();
                ++len;
                if (lastByte < 0) {
                    throw new SerializerException("Unexpected end of stream on line " + this.lineNo, new Object[0]);
                }
                if (lastByte != 46 && (lastByte < 48 || lastByte > 57)) {
                    throw new SerializerException("No decimal after negative indicator.", new Object[0]);
                }
            } else if (lastByte == 48) {
                lastByte = this.read();
                ++len;
                if (lastByte == 120) {
                    while ((lastByte = this.read()) != -1) {
                        if (lastByte >= 48 && lastByte <= 57 || lastByte >= 97 && lastByte <= 102 || lastByte >= 65 && lastByte <= 70) {
                            ++len;
                            continue;
                        }
                        this.unread();
                        break;
                    }
                    return new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
                }
                while ((lastByte = this.read()) != -1) {
                    if (lastByte >= 48 && lastByte <= 55) {
                        ++len;
                        continue;
                    }
                    this.unread();
                    break;
                }
                return new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
            }
            while (lastByte >= 48 && lastByte <= 57) {
                ++len;
                lastByte = this.read();
                if (lastByte >= 0) continue;
            }
            if (lastByte == 46) {
                ++len;
                lastByte = this.read();
                if (lastByte >= 0) {
                    while (lastByte >= 48 && lastByte <= 57) {
                        ++len;
                        lastByte = this.read();
                        if (lastByte >= 0) continue;
                    }
                }
            }
            if (lastByte == 101 || lastByte == 69) {
                ++len;
                lastByte = this.read();
                if (lastByte >= 0) {
                    if (lastByte == 45 || lastByte == 43) {
                        ++len;
                        lastByte = this.read();
                    }
                    while (lastByte >= 48 && lastByte <= 57) {
                        ++len;
                        lastByte = this.read();
                        if (lastByte >= 0) continue;
                    }
                }
            }
            Token token = new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
            if (lastByte < 0 || lastByte == 32 || lastByte == 9 || lastByte == 10 || lastByte == 13 || lastByte == 58 || lastByte == 125 || lastByte == 93 || lastByte == 44 || lastByte == 59 || lastByte == 35) {
                if ("{}:=()<>,;#[]".indexOf(lastByte) >= 0) {
                    this.unread();
                }
                return token;
            }
            throw new SerializerException("Wrongly terminated number: %c.", Character.valueOf((char)lastByte));
        }

        private Token nextIdentifier() throws SerializerException {
            int r;
            int startOffset = this.readOffset;
            int startLinePos = this.linePos;
            int len = 1;
            boolean dot = false;
            while ((r = this.read()) != -1) {
                if (r == 46) {
                    if (dot) {
                        throw new SerializerException("Identifier with double '..' at line %d pos %d", this.lineNo, startLinePos);
                    }
                    dot = true;
                    ++len;
                    continue;
                }
                dot = false;
                if (r == 95 || r >= 48 && r <= 57 || r >= 97 && r <= 122 || r >= 65 && r <= 90) {
                    ++len;
                    continue;
                }
                this.unread();
                break;
            }
            Token token = new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
            if (dot) {
                throw new SerializerException("Identifier trailing with '.' at line %d pos &d", this.lineNo, startLinePos);
            }
            if (r == -1 || r == 32 || r == 9 || r == 10 || r == 13 || r == 58 || r == 125 || r == 93 || r == 44 || r == 59 || r == 35 || "{}:=()<>,;#[]".indexOf(r) >= 0) {
                return token;
            }
            throw new SerializerException("Wrongly terminated identifier: %c.", Character.valueOf((char)r));
        }

        public String getLine(int line) throws IOException {
            if (line < 1) {
                throw new IllegalArgumentException("Oops!!!");
            }
            this.readOffset = -1;
            this.lineNo = 1;
            this.linePos = -1;
            while (--line > 0) {
                if (IOUtils.skipUntil((InputStream)this, (byte)10)) continue;
                throw new IOException("Oops");
            }
            return IOUtils.readString((InputStream)this, (String)PrettySerializer.NEWLINE);
        }

        public Binary readBinaryUntil(char end) throws SerializerException {
            int r;
            int startOffset = this.readOffset + 1;
            int startLinePos = this.linePos;
            while ((r = this.read()) != -1) {
                if (r == end) {
                    return Binary.fromBase64((String)new Slice(this.buffer, startOffset, this.readOffset - startOffset).asString());
                }
                if (r != 32 && r != 10 && r != 13 && r != 9) continue;
                throw new SerializerException("Illegal char in binary", new Object[0]);
            }
            throw new SerializerException("unexpected end of binary data on line " + startLinePos, new Object[0]);
        }
    }

    private static class Token
    extends Slice {
        public static final char kMessageStart = '{';
        public static final char kMessageEnd = '}';
        public static final char kKeyValueSep = ':';
        public static final char kLineSep1 = ',';
        public static final char kLineSep2 = ';';
        public static final char kLiteralEscape = '\\';
        public static final char kLiteralQuote = '\'';
        public static final char kLiteralDoubleQuote = '\"';
        public static final char kListStart = '[';
        public static final char kListEnd = ']';
        public static final char kShellComment = '#';
        public static final String kSymbols = "{}:=()<>,;#[]";
        private static final Pattern RE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
        private static final Pattern RE_INTEGER = Pattern.compile("-?(0|[1-9][0-9]*|0[0-7]+|0x[0-9a-fA-F]+)");
        private final int lineNo;
        private final int linePos;

        public Token(byte[] fb, int off, int len, int lineNo, int linePos) {
            super(fb, off, len);
            this.lineNo = lineNo;
            this.linePos = linePos;
        }

        public boolean isSymbol(char symbol) {
            return this.len == 1 && this.fb[this.off] == symbol;
        }

        public boolean isStringLiteral() {
            return this.length() > 1 && this.charAt(0) == '\"' && this.charAt(-1) == '\"';
        }

        public boolean isIdentifier() {
            return RE_IDENTIFIER.matcher(this.asString()).matches();
        }

        public boolean isInteger() {
            return RE_INTEGER.matcher(this.asString()).matches();
        }

        public String decodeLiteral() {
            String tmp = this.substring(1, -1).asString();
            int l = tmp.length();
            StringBuilder out = new StringBuilder(l);
            boolean esc = false;
            for (int i = 0; i < l; ++i) {
                if (esc) {
                    esc = false;
                    char ch = tmp.charAt(i);
                    switch (ch) {
                        case 'b': {
                            out.append('\b');
                            break;
                        }
                        case 'f': {
                            out.append('\f');
                            break;
                        }
                        case 'n': {
                            out.append('\n');
                            break;
                        }
                        case 'r': {
                            out.append('\r');
                            break;
                        }
                        case 't': {
                            out.append('\t');
                            break;
                        }
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            out.append(ch);
                            break;
                        }
                        case 'u': {
                            int cp;
                            String n;
                            if (l < i + 5) {
                                out.append('?');
                            } else {
                                n = tmp.substring(i + 1, i + 5);
                                try {
                                    cp = Integer.parseInt(n, 16);
                                    out.append((char)cp);
                                }
                                catch (NumberFormatException e) {
                                    out.append('?');
                                }
                            }
                            i += 4;
                            break;
                        }
                        case '0': 
                        case '1': {
                            int cp;
                            String n;
                            if (l < i + 3) {
                                out.append('?');
                            } else {
                                n = tmp.substring(i, i + 2);
                                try {
                                    cp = Integer.parseInt(n, 8);
                                    out.append((char)cp);
                                }
                                catch (NumberFormatException e) {
                                    out.append('?');
                                }
                            }
                            i += 2;
                            break;
                        }
                        default: {
                            out.append('?');
                            break;
                        }
                    }
                    continue;
                }
                if (tmp.charAt(i) == '\\') {
                    esc = true;
                    continue;
                }
                out.append(tmp.charAt(i));
            }
            return out.toString();
        }

        public String toString() {
            return String.format("Token('%s',%d:%d-%d)", this.asString(), this.lineNo, this.linePos, this.linePos + this.len);
        }
    }
}

