/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;
import net.morimekta.providence.PException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PExceptionDescriptor;
import net.morimekta.providence.descriptor.PExceptionDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.serializer.ApplicationExceptionType;
import net.morimekta.util.Strings;

public class ApplicationException
extends PException
implements PMessage<ApplicationException>,
Serializable,
Comparable<ApplicationException> {
    private static final long serialVersionUID = 6590039153455193300L;
    private static final ApplicationExceptionType kDefaultId = ApplicationExceptionType.UNKNOWN;
    private final String mMessage;
    private final ApplicationExceptionType mId;
    private volatile int tHashCode;
    public static final PExceptionDescriptor<ApplicationException, _Field> kDescriptor = new _Descriptor();

    private ApplicationException(_Builder builder) {
        super(ApplicationException.createMessage(builder.mMessage, builder.mId));
        this.mMessage = builder.mMessage;
        this.mId = builder.mId;
    }

    public ApplicationException(String pMessage, ApplicationExceptionType pId) {
        super(ApplicationException.createMessage(pMessage, pId));
        this.mMessage = pMessage;
        this.mId = pId;
    }

    private static String createMessage(String pMessage, ApplicationExceptionType pId) {
        StringBuilder out = new StringBuilder();
        out.append('{');
        boolean first = true;
        if (pMessage != null) {
            first = false;
            out.append("message:").append('\"').append(Strings.escape((CharSequence)pMessage)).append('\"');
        }
        if (pId != null) {
            if (!first) {
                out.append(',');
            }
            out.append("id:").append(pId.toString());
        }
        out.append('}');
        return out.toString();
    }

    public boolean hasMessage() {
        return this.mMessage != null;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    public boolean hasId() {
        return this.mId != null;
    }

    public ApplicationExceptionType getId() {
        return this.hasId() ? this.mId : kDefaultId;
    }

    @Override
    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasMessage();
            }
            case 2: {
                return this.hasId();
            }
        }
        return false;
    }

    @Override
    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasMessage() ? 1 : 0;
            }
            case 2: {
                return this.hasId() ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getMessage();
            }
            case 2: {
                return this.getId();
            }
        }
        return null;
    }

    @Override
    public boolean compact() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ApplicationException)) {
            return false;
        }
        ApplicationException other = (ApplicationException)o;
        return Objects.equals(this.mMessage, other.mMessage) && Objects.equals(this.mId, other.mId);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(ApplicationException.class, _Field.MESSAGE, this.mMessage, _Field.ID, this.mId);
        }
        return this.tHashCode;
    }

    @Override
    public String toString() {
        return "service.ApplicationException" + this.asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.mMessage != null) {
            first = false;
            out.append("message:").append('\"').append(Strings.escape((CharSequence)this.mMessage)).append('\"');
        }
        if (this.mId != null) {
            if (!first) {
                out.append(',');
            }
            out.append("id:").append(this.mId.toString());
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ApplicationException other) {
        int c = Boolean.compare(this.mMessage != null, other.mMessage != null);
        if (c != 0) {
            return c;
        }
        if (this.mMessage != null && (c = this.mMessage.compareTo(other.mMessage)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mId != null, other.mId != null);
        if (c != 0) {
            return c;
        }
        if (this.mId != null && (c = Integer.compare(this.mId.getValue(), this.mId.getValue())) != 0) {
            return c;
        }
        return 0;
    }

    public static PExceptionDescriptorProvider<ApplicationException, _Field> provider() {
        return new _Provider();
    }

    @Override
    public PExceptionDescriptor<ApplicationException, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    static /* synthetic */ ApplicationExceptionType access$200() {
        return kDefaultId;
    }

    public static class _Builder
    extends PMessageBuilder<ApplicationException> {
        private BitSet optionals = new BitSet(2);
        private String mMessage;
        private ApplicationExceptionType mId;

        public _Builder() {
        }

        public _Builder(ApplicationException base) {
            this();
            if (base.hasMessage()) {
                this.optionals.set(0);
                this.mMessage = base.mMessage;
            }
            if (base.hasId()) {
                this.optionals.set(1);
                this.mId = base.mId;
            }
        }

        public _Builder merge(ApplicationException from) {
            if (from.hasMessage()) {
                this.optionals.set(0);
                this.mMessage = from.getMessage();
            }
            if (from.hasId()) {
                this.optionals.set(1);
                this.mId = from.getId();
            }
            return this;
        }

        public _Builder setMessage(String value) {
            this.optionals.set(0);
            this.mMessage = value;
            return this;
        }

        public boolean isSetMessage() {
            return this.optionals.get(0);
        }

        public _Builder clearMessage() {
            this.optionals.clear(0);
            this.mMessage = null;
            return this;
        }

        public _Builder setId(ApplicationExceptionType value) {
            this.optionals.set(1);
            this.mId = value;
            return this;
        }

        public boolean isSetId() {
            return this.optionals.get(1);
        }

        public _Builder clearId() {
            this.optionals.clear(1);
            this.mId = null;
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setMessage((String)value);
                    break;
                }
                case 2: {
                    this.setId((ApplicationExceptionType)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearMessage();
                    break;
                }
                case 2: {
                    this.clearId();
                }
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public ApplicationException build() {
            return new ApplicationException(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<ApplicationException> {
        private _Factory() {
        }

        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PExceptionDescriptorProvider<ApplicationException, _Field> {
        private _Provider() {
        }

        @Override
        public PExceptionDescriptor<ApplicationException, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PExceptionDescriptor<ApplicationException, _Field> {
        public _Descriptor() {
            super("service", "ApplicationException", new _Factory(), true);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        MESSAGE(1, PRequirement.DEFAULT, "message", PPrimitive.STRING.provider(), null),
        ID(2, PRequirement.DEFAULT, "id", ApplicationExceptionType.provider(), new PDefaultValueProvider<ApplicationExceptionType>(ApplicationException.access$200()));

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        @Override
        public int getKey() {
            return this.mKey;
        }

        @Override
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Override
        public PType getType() {
            return this.getDescriptor().getType();
        }

        @Override
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Override
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ApplicationException._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return MESSAGE;
                }
                case 2: {
                    return ID;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "message": {
                    return MESSAGE;
                }
                case "id": {
                    return ID;
                }
            }
            return null;
        }
    }
}

