/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;

public class TypeUtils {
    private static final String NULL = "null";

    public static String asString(PMessage<?> message) {
        if (message == null) {
            return NULL;
        }
        return message.asString();
    }

    public static String asString(Object o) {
        if (o == null) {
            return NULL;
        }
        if (o instanceof PMessage) {
            return TypeUtils.asString((PMessage)o);
        }
        return Strings.asString((Object)o);
    }

    public static boolean equalsQualifiedName(PDescriptor a, PDescriptor b) {
        if (a == null != (b == null)) {
            return false;
        }
        if (a == null) {
            return true;
        }
        return a.getQualifiedName(null).equals(b.getQualifiedName(null));
    }

    private static <T extends PMessage<T>> int compare(T m1, T m2) {
        int c = 0;
        c = ((PDeclaredDescriptor)m1.descriptor()).getQualifiedName(null).compareTo(((PDeclaredDescriptor)m2.descriptor()).getQualifiedName(null));
        if (c != 0) {
            return c;
        }
        for (PField field : m1.descriptor().getFields()) {
            c = Boolean.compare(m1.has(field.getKey()), m2.has(field.getKey()));
            if (c != 0) {
                return c;
            }
            if (!m1.has(field.getKey()) || (c = TypeUtils.compare((Comparable)m1.get(field.getKey()), (Comparable)m2.get(field.getKey()))) == 0) continue;
            return c;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compare(T o1, T o2) {
        if (o1 == null || o2 == null) {
            return Boolean.compare(o1 != null, o2 != null);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return Boolean.compare((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Short && o2 instanceof Short) {
            return Short.compare((Short)o1, (Short)o2);
        }
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return Integer.compare((Integer)o1, (Integer)o2);
        }
        if (o1 instanceof Long && o2 instanceof Long) {
            return Long.compare((Long)o1, (Long)o2);
        }
        if (o1 instanceof Double && o2 instanceof Double) {
            return Double.compare((Double)o1, (Double)o2);
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)((Object)o1)).compareTo((String)((Object)o2));
        }
        if (o1 instanceof Binary && o2 instanceof Binary) {
            return ((Binary)o1).compareTo((Binary)o2);
        }
        if (o1 instanceof PEnumValue && o2 instanceof PEnumValue) {
            return Integer.compare(((PEnumValue)o1).getValue(), ((PEnumValue)o2).getValue());
        }
        if (o1 instanceof PMessage && o2 instanceof PMessage) {
            return TypeUtils.compare((PMessage)o1, (PMessage)o2);
        }
        if (o1 instanceof Map && o2 instanceof Map || o1 instanceof Set && o2 instanceof Set || !(o1 instanceof List) || o2 instanceof List) {
            // empty if block
        }
        return 0;
    }
}

